/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
 
(function() {
    var jsMenu = {};
    var _menuPrivate = new nokia.device.MenuBase();

    jsMenu.__defineGetter__("size", function() {
        return _menuPrivate.getMenu().length;
    });
    
    jsMenu.__defineGetter__("title", function() {
        return menuCPP.title;
    });
    
    jsMenu.__defineSetter__("title", function(t) {
        menuCPP.title = t;
    });

    jsMenu.addMenuItem = function(menuItem) {
        var id = menuItemFactoryCPP.nativeId(menuItem);
        if (menuCPP && id != -1) {
            menuCPP.append(id);
            _menuPrivate.add(menuItem);
        }
    };
    
    jsMenu.removeMenuItem = function(menuItem) {
        var id = menuItemFactoryCPP.nativeId(menuItem);
        if (menuCPP && id != -1) {
            menuCPP.remove(id);
            _menuPrivate.remove(menuItem);
        }
    };
    
    jsMenu.insertMenuItemBefore = function(menuItem, index) {
        var id = menuItemFactoryCPP.nativeId(menuItem);
        if (menuCPP && id != -1) {
            menuCPP.insert(id, index);
            _menuPrivate.insert(menuItem, index);
        }
    };
    
    
    jsMenu.clear = function() {
        _menuPrivate.clear();
        if (menuCPP) {
            menuCPP.clear();
        }
    };
    
    jsMenu.item = function(index) {
        return _menuPrivate.item(index);
    }

    nokia.device.menu = jsMenu;
})();
