/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef ACTION_H
#define ACTION_H

#ifdef Q_OS_MAEMO6
#include <DuiAction>
#else
#include <QAction>
#endif

#include <QList>

class QMenu;

namespace WRT {

class Action:
#ifdef Q_OS_MAEMO6
    public DuiAction
#else
    public QAction
#endif
{
    Q_OBJECT
public:

    enum Location {
        ViewMenuLocation,
        ContextMenuLocation,
        ToolBarLocation,
        UnKnown
    };

    explicit Action(QObject * parent = 0);
    Action(const QString& text, QObject * parent = 0);
    virtual ~Action();
    void setId(int id);
    int id();

    void setLocation(Location location);
    Location location();

#if !defined(SUPPORT_ONLY_FLAT_MENUS)
    void addSubAction(Action* action);
    void removeSubAction(Action* action);
    void insertSubAction(Action* action, int beforeIndex);
#endif

    QList<QAction*> subActions() const;

signals:
    void subActionsAdded();
    void subActionsRemoved();

private:
    int m_id;
    Location m_location;
    QMenu* m_subAction;

};

}

#endif // ACTION_H
