/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "w3cjswidget.h"
#include "jiljswidget.h"
#include "wrtwidgetcontainer.h"

using namespace WRT;

JILJSWidget::JILJSWidget(WidgetContainer* wrtWidgetContainer) :
    W3CJSWidget(wrtWidgetContainer)
{
}

JILJSWidget::~JILJSWidget ()
{
}

void JILJSWidget::notificationRecieved(WidgetContainer::WrtWidgetNotify value)
{

 switch (value) {
     case WidgetContainer::WrtWidgetToForeGround:
         widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onWakeup) != 'undefined') && (widget.onWakeup != null)){widget.onWakeup();}");
         break;

     case WidgetContainer::WrtWidgetFocusIn:
         widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onFocus) != 'undefined') && (widget.onFocus != null)){widget.onFocus();}");

         // Do the W3CJSWidget action for focus in, as well
         W3CJSWidget::notificationRecieved(value);
         break;

#if defined(Q_OS_SYMBIAN)
     case WidgetContainer::WrtWidgetToFullscreen:
         widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onMaximize) != 'undefined') && (widget.onMaximize != null)){widget.onMaximize();}");
         break;
#endif

#if 0
     case WidgetContainer::WrtWidgetOnRestore:
         //TO BE DONE
      break;
#endif

     default:
         W3CJSWidget::notificationRecieved(value);
         break;
 }
}

QVariant JILJSWidget::preferenceForKey(const QVariant& key)
{
    return SuperJSWidget::preferenceForKey(key);
}

void JILJSWidget::setPreferenceForKey(const QVariant& value, const QVariant& key)
{
    SuperJSWidget::setPreferenceForKey( key , value);
}


