/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include <stdlib.h>
#include <QDebug>

#include "utils.h"
#include "wrtsettings.h"

namespace WRT {
namespace Maemo {


QStringList Utils::getPreferredLanguages()
{
    QStringList languages;

    // Read from the Qt locale system and write to the wrtsettings
    QString systemLanguage = QLocale::system().name().toLower().replace(QString("_"),QString("-"));
    languages.append(systemLanguage);
    WrtSettings::createWrtSettings()->setValue("UserAgentLanguage", systemLanguage);

    return languages;
}


QString Utils::convertLanguage(QString lang)  {
    int count = lang.count();

    if (count == 5) {
        QString convertedString = lang.toLower().replace(QString("_"),QString("-"));
        return convertedString;
    }
    else {
        return lang;
    }
}


bool Utils::recursiveCopy(QDir src, QDir dst, bool overwrite) {

    QStringList subdirs = src.entryList(QDir::AllDirs|QDir::NoDotAndDotDot);
    if (subdirs.size() > 0) {
        QDir subsrc;
        QDir subdst;
        foreach (QString str, subdirs) {
            subsrc = src;
            subdst = dst;

            if (!subdst.exists(str)) {

                subdst.mkdir(str);

            }

            if (subsrc.cd(str) &&  subdst.cd(str)) {
                if (!recursiveCopy(subsrc,subdst,overwrite))
                    return false;

            } else {
                //Some of the dirs had access restrictions
            }
        }
    }
    //Copy the stuff here


    QStringList sourcefiles = src.entryList(QDir::Files|QDir::Hidden|QDir::NoDotAndDotDot);
    QStringList destfiles = dst.entryList(QDir::Files|QDir::Hidden|QDir::NoDotAndDotDot);
    foreach(QString fp,sourcefiles) {
        if (destfiles.contains(fp)) {
            if (overwrite) {
                dst.remove(fp);
            } else {
                //File already exists and we have no overwrite
                return false;
            }
        }
        QFile file (src.filePath(fp));
        if (file.exists()) {
            QString newname = dst.absolutePath().append("/").append(fp);

            if (!file.copy(newname)) {
                return false;
            }
        }
    }
    return true;
}


QSize Utils::parseSize(QString s ) {
    if ( s.startsWith(QLatin1String("@Size(")) ) {
        // Remove @Size(
        s.remove(0,6);
        if ( s.endsWith( ")" ) ) {
            s.remove( s.length()-1,s.length());
        }
        QStringList args = s.split(" ");
        if (args.size() == 2)
            return QSize( args[0].toInt(), args[1].toInt());


    }

    // In the end return error value if we were not able to parse
    return QSize(-1,-1);
}




}}
