/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTWIDGETREPLY_H__
#define __WRTWIDGETREPLY_H__

#include <QByteArray>
#include <QFile>
#include <QNetworkReply>
#include <QNetworkRequest>

namespace WRT
{
    class Storage;

    class WrtWidgetReply : public QNetworkReply
    {
    Q_OBJECT
    public:
        WrtWidgetReply(const QNetworkRequest& request, Storage* storage,
                       const QString& = "widget", // protocol
                       const QString =""); //widgetrootpath
        ~WrtWidgetReply();
        virtual void abort();
        virtual qint64 readData(char* data, qint64 size);
        virtual qint64 bytesAvailable () const;
        virtual bool isSequential() const { return false; }

        virtual qint64 pos() const { return m_position; }
        virtual qint64 size() const { return m_content.size(); }
        virtual bool seek(qint64 pos) { if (pos <= m_content.size()) { m_position = pos; return true; } return false; }
        virtual bool atEnd() const { return (m_position == m_content.size()); }
        virtual bool reset() { m_position = 0; return true;}
        virtual bool canReadLine() const { return false; }

    private slots:
        void sendData();
        void sendFinished();
        void sendError();

    private:
        QString toLocalFileName(QUrl& url);
        bool getLocalizedUrl(QUrl& newUrl, const QUrl& reqUrl);


    private:
        QString m_protocol;
        QString m_fileName;
        QFile m_file;
        QByteArray m_content;
        qint64 m_position;
#ifdef CWRT_WIDGET_FILES_IN_SECURE_STORAGE
        Storage* m_storage;
#endif
    };
}
#endif
