/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTNETWORKREPLY_H__
#define __WRTNETWORKREPLY_H__

#include <QNetworkReply>

namespace WRT
{
    class WrtNetworkReply : public QNetworkReply
    {
    Q_OBJECT

    public:
        WrtNetworkReply(QNetworkAccessManager::Operation op, const QNetworkRequest &request);
        ~WrtNetworkReply();
        virtual void abort();
        virtual qint64 readData(char* data, qint64 maxlen);
        virtual qint64 bytesAvailable() const;
        void setReply(QNetworkReply* reply);

    public slots:
        void handleReadyRead();
        void handleMetaDataChanged();
        void handleFinished();
        void ignoreSslErrors();

    signals:
        void aborted(WrtNetworkReply* reply);

    private:
        void bridgeReplyData();
    private:
        QNetworkReply* m_reply;
        QByteArray m_readBuffer;
    };
}
#endif
