#
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
HEADERS += \
    $$PWD/locationService.h \
    $$PWD/serviceloader.h \
    $$PWD/serviceprovider.h \
    $$PWD/serviceproxy.h \
    $$PWD/WebServices/SchemeHandler.h

SOURCES += \
    $$PWD/locationService.cpp \
    $$PWD/serviceloader.cpp \
    $$PWD/serviceproxy.cpp \
    $$PWD/WebServices/SchemeHandler.cpp

symbian: {
    INCLUDEPATH +=  $$PWD/../utilities/WrtTelService
    LIBS += -lWrtTelService -lcommonui -lServiceHandler -lapmime -lefsrv -lapparc
}

unix:!symbian {
    maemo6 | maemo5 {
        HEADERS += $$PWD/WebServices/platform/maemo/customschemehandler.h
        SOURCES += $$PWD/WebServices/platform/maemo/customschemehandler.cpp

	headers_services_tmp_webservices.files += $$PWD/WebServices/platform/maemo/customschemehandler.h
    }

    headers_services_tmp.files = \
        $$PWD/locationService.h \
        $$PWD/serviceloader.h \
        $$PWD/serviceprovider.h \
        $$PWD/serviceproxy.h
    headers_services_tmp.path = $$CWRT_INSTALL_INC_DIR/wrt/services-tmp

    headers_services_tmp_webservices.files += $$PWD/WebServices/SchemeHandler.h
    headers_services_tmp_webservices.path = $$CWRT_INSTALL_INC_DIR/wrt/services-tmp/WebServices

    headers_services_tmp_downloadservice.files += $$PWD/DownloadService/webjsdownload.h
    headers_services_tmp_downloadservice.path = $$CWRT_INSTALL_INC_DIR/wrt/services-tmp/DownloadService

    INSTALLS += headers_services_tmp headers_services_tmp_webservices headers_services_tmp_downloadservice
}

contains(DEFINES, FEED_SERVICE) {
    HEADERS += $$PWD/FeedServices/FeedServices.h
    SOURCES += $$PWD/FeedServices/FeedServices.cpp

    unix:!symbian {
        headers_services_tmp_feedservices.files = $$PWD/FeedServices/FeedServices.h
        headers_services_tmp_feedservices.path = $$CWRT_INSTALL_INC_DIR/wrt/services-tmp/FeedServices

        INSTALLS += headers_services_tmp_feedservices
    }
}

contains( what, ninetwo ) {
    QT += webkit
    DEFINES += CWRT_BUILDING_NINETWO
}
