/*
 * ============================================================================
 *  Name        : telephonyservice.h
 *  Part of     : serviceframework / WRT
 *  Description : Qt class for telephony service
 *  Version     :
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef TELEPHONYSERVICE_H_
#define TELEPHONYSERVICE_H_

//INCLUDES
#include <QtCore>

#include "servicesecurityinterface.h"
#include "telephonyinterface.h"

// FORWARD DECLARATION

class QBuffer;
class QFile;
class CTelephonyProvider;

// CLASS DECLARATION

/**
*  The class implements the interface for telephony service
*  described in ITelephonyinterface class
*  @lib telephonyserviceplugin.qtplugin
*  @since x.y
*/
class TelephonyService : public QObject,
                    public ITelephony,
                    public IServiceSecurity
{
    Q_OBJECT
    Q_INTERFACES(ITelephony)

public:
    //public interfaces:

    /**
    * Constructor
    */
    TelephonyService();

    /**
    * Destructor
    */
    virtual ~TelephonyService();

    /**
    * Provides implementation for setSecuritySession derived from
    * IServiceSecurity.
    * Needed to handle capabilities.
    * @since x.y
    * @param aSecSession - Security Manager session
    * @return none
    */
    void setSecuritySession(WRT::SecSession *secSession);

public slots:
    //Public Slots

    /**
    * Provides implementation for initiateVoiceCall() function defined in ITelephony.
    * This is a sycnhronous method.
    * @phoneNumber
    * @return  Map containing errorCode,errorMessage,transactionId.Content of this map is given
    * below :
    * --------------------------------------------------------------------------------
    * |Key                 |DataType  |String
    * --------------------------------------------------------------------------------
    * |errorCode           | int      |error code in case of error, 0 otherwise.
    * ---------------------------------------------------------------------------------
    * |errorMessage        | string   |error description in engineering english.
    * --------------------------------------------------------------------------------
    * |transactionId       | int      |Unique Id identifying this request in case of success.
    * ---------------------------------------------------------------------------------
    * @since x.y
    */
    QVariant initiateVoiceCall( QString phoneNumber );

private:

    /**
    *  Handle to security session
    */
    WRT::SecSession *_sec_session;

    CTelephonyProvider* m_provider;
};

#endif //TELEPHONYSERVICE_H_
