/*
 * ============================================================================
 *  Name        : telephonyservice.cpp
 *  Part of     : serviceframework / WRT
 *  Description : Qt class for telephony service
 *  Version     :
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

//INCLUDES
#include <QtCore>

#include "secsession.h"
#include "telephonyservice.h"
#include "telephonyprovider.h"
#include "constants.h"

// --------------------------------------------------------------------
// TelephonyService::TelephonyService()
// Constructor.
// --------------------------------------------------------------------
TelephonyService::TelephonyService()
    {
    m_provider = CTelephonyProvider::NewL();
    }

// --------------------------------------------------------------------
// TelephonyService::~TelephonyService()
// Destructor.
// --------------------------------------------------------------------
TelephonyService::~TelephonyService()
    {
    delete m_provider;
    }

// --------------------------------------------------------------------
// TelephonyService::setSecuritySession()
// Provides implementation for setSecuritySession derived
// from IServiceSecurity.
// --------------------------------------------------------------------
void TelephonyService::setSecuritySession(WRT::SecSession *secSession)
    {
    _sec_session = secSession;
    }

// --------------------------------------------------------------------
// TelephonyService::initiateVoiceCall()
// Makes a voice call to user specified phone number.
// --------------------------------------------------------------------
QVariant TelephonyService::initiateVoiceCall( QString phoneNumber )
    {
    QVariantMap retVal;
    int err = KErrNone;
    TPtrC phoneNumberPtr(reinterpret_cast<const TUint16*>(phoneNumber.utf16()));
    if ( phoneNumberPtr.Length() > KMaxTelNumSize )
        {
        err = KErrArgument;
        retVal[KErrMsg] = "Number is too large";
        }
    else
        {
        err = m_provider->MakeNewCall(phoneNumberPtr);
        if ( KErrInUse == err )
            {
            retVal[KErrMsg] = "Service is in use";
            }
        }
    retVal[KErrCode] = err;
    return retVal;
    }

// End of file
