/*
* ============================================================================
*  Name        : qsensorserviceinterface.h
*  Part of     : serviceproviders / WRT
*  Description : Interface for sensorservice
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QSENSORSERVICEINTERFACE_H
#define QSENSORSERVICEINTERFACE_H

//QT Include
#include <QVariant>
#include <QString>
#include <QMap>

//Service Framework Include
#include "servicebase.h"

static const char* KISensorId = "com.nokia.ISensor/1.0";

// ITypeTest interface id.For Future use
static const ServiceInterfaceInfo KISensorInfo =
{
    KISensorId, 0
};

class ISensor : public IServiceBase
{
public:

    /**
     * This method is used to get the list of channels supported by the device.
     * This is a Synchronous API
     * @since  x.y
     *
     * @return list of strings
     */

     virtual QVariant getChannels ()  =  0;

    /**
     * Registers for notifications from a particular channel.
     * This is an asynchronous method. If the notification for a particular
     * channel has already been registered, and subsequently a call made again,
     * api will return an error.
     * @since x.y
     *
     * @param aChannel - Name of the channel as specified in the channel
     *                   descriptor.The supported channels are AccelerometerAxis,
     *                   Orientation and Rotation.
     * @param transId  - Connection id from JS .
     * @return Map Containing ErrorCode and ErrorMessage.
     */

     virtual QVariant startChannel( const QString& aChannel,const int transId ) = 0;

    /**
     * Stops the notifications (started by startChannel) for the channel specified.
     * This is a synchronous method.
     * @since x.y
     *
     * @param aChannel - Name of the channel.
     * @return Map Containing ErrorCode and ErrorMessage.
     */

     virtual QVariant stopChannel( const QString& aChannel ) = 0;

    /**
     * Gets the scalefactor value for the specified channel .
     * This is a synchronous method.
     * @since x.y
     *
     * @param aChannel - Name of the channel.
     * @return Map Containing ScaleFactor,ErrorCode and ErrorMessage.
     */

     virtual QVariant getScaleFactor( const QString& aChannel ) = 0;

     #ifdef __MAEMO__
     virtual QVariant setDesiredUpdateFrequency( const QString& aChannel,const int msec) = 0;
     #endif

     /**
      * Gets the data for the specified channel.
      * This is a synchronous method.
      * @since x.y
      *
      * @param aChannel - Name of the channel.
      * @return Map Containing Channel Information, ErrorCode and ErrorMessage.
      */
     #ifndef __MAEMO__
     virtual QVariant getChannelData( const QString& aChannel ) = 0;
     #else
     virtual QVariant getChannelEvent(const QString& aChannel) = 0;
     #endif

};
Q_DECLARE_INTERFACE(ISensor, KISensorId);

#endif //QSENSORSERVICEINTERFACE_H
