/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __QMESSAGINGITERATOR_H
#define __QMESSAGINGITERATOR_H

//QT Include
#include <QVariant>

//Service framework include
#include "iterable.h"

#include "qmessagingconstants.h"
#include "messagefilter.h"

/**
 * This is instantiated from qcontactservice when it gets a coreclass iterator.
 * Then it will translate core class datastrucure to qcontactData struture to satisfy from CJSE specs
 */
class QMessagingIterator : public QObject, public WRT::IIterable //Mandatory to inherit this
    {
Q_OBJECT

public:

    /**
     * constructor
     * @since x.y
     * @return
     */
    QMessagingIterator(QVariantList aList, int aTransactionId);

    /**
     * destructor
     * @since x.y
     * @param
     * @return
     */
    ~QMessagingIterator();

public slots:

    /**
     * resets the index, if present
     * @since x.y
     * @param
     * @return
     */
    void reset();

    /**
     */
    virtual bool hasNext();

    /**
     */
    virtual QVariant next();

    /**
     */
    void close();

private:
    QVariantList iList;
    QListIterator<QVariant> * iIterator;
    int iTransactionId;
    };

#endif //__QMESSAGING_ITERATOR_H_
