/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "qmessagingiterator.h"
#include <QDebug>

QMessagingIterator::QMessagingIterator(QVariantList aList, int aTransactionId)
                        : iList (aList), iTransactionId(aTransactionId)
{
    iIterator = new QListIterator<QVariant>(iList);
}

/**
* Resets the iterator
* @return none
*/
void QMessagingIterator::reset()
{
    delete iIterator;
    iIterator = new QListIterator<QVariant>(iList);
}


QMessagingIterator::~QMessagingIterator()
{
    qDebug() << "QMessagingIterator::~QMessagingIterator. id" << iTransactionId;
    delete iIterator;
    iIterator = NULL;
    qDebug() << "QMessagingIterator::~QMessagingIterator end";
}

bool QMessagingIterator::hasNext()
{
    return iIterator->hasNext();
}

/**
* Get current item in the collection and get ready for next item.
*
* @return current data entry
*
*/
QVariant QMessagingIterator::next()
{
    if (iIterator->hasNext())
    {
        return iIterator->next();
    }
    qDebug() << "QMessagingIterator::next. RETURN NULL";
    return NULL; // Check it
}


void QMessagingIterator::close()
{
    qDebug() << "QMessagingIterator::close";
}
