# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU (Lesser) General Public License as
#  published by the Free Software Foundation, version 2.1 of the License.
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  (Lesser) General Public License for more details. You should have
#  received a copy of the GNU (Lesser) General Public License along
#  with this program. If not, see .

TEMPLATE = lib

CONFIG += plugin
!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}
symbian {
	CONFIG(debug):MEDIASVC_SRC_PATH = ./platform/s60/
	CONFIG(debug):MEDIASVC_INC_PATH = ./platform/s60/
	CONFIG(release):MEDIASVC_SRC_PATH = ./platform/s60/
	CONFIG(release):MEDIASVC_INC_PATH = ./platform/s60/
	
	HEADERS = $$MEDIASVC_INC_PATH/asyncreqobserver.h \
						$$MEDIASVC_INC_PATH/mediainfo.h \
						$$MEDIASVC_INC_PATH/mediaservicecallback.h \
						$$MEDIASVC_INC_PATH/mgconsts.h \
						$$MEDIASVC_INC_PATH/mgimageresolution.h \
						$$MEDIASVC_INC_PATH/mgmediacontainer.h \
						$$MEDIASVC_INC_PATH/mgmresolution.h \
						$$MEDIASVC_INC_PATH/mgmusiccollection.h \
						$$MEDIASVC_INC_PATH/mgoperationobserver.h \
						$$MEDIASVC_INC_PATH/mgservice.h \
						$$MEDIASVC_INC_PATH/mgservice.hrh \
						$$MEDIASVC_INC_PATH/mgthumbnailgeneration.h \
						$$MEDIASVC_INC_PATH/mgthumbnailobserver.h \
						$$MEDIASVC_INC_PATH/mgthumbobserver.h \
						$$MEDIASVC_INC_PATH/mgvideoresolution.h \
						$$MEDIASVC_INC_PATH/mqueryobserver.h \				
						./qmediaserviceinterface.h \
				./qmediaserviceplugin.h \
				$$MEDIASVC_INC_PATH/qmediaservice.h \
					$$MEDIASVC_INC_PATH/qmediagetlistiterator.h
	
	SOURCES =  $$MEDIASVC_SRC_PATH/mgservice.cpp \
						$$MEDIASVC_SRC_PATH/mgthumbobserver.cpp \
						$$MEDIASVC_SRC_PATH/mgthumbnailgeneration.cpp \
						$$MEDIASVC_SRC_PATH/mgmresolution.cpp \ 
						$$MEDIASVC_SRC_PATH/mgimageresolution.cpp \
						$$MEDIASVC_SRC_PATH/mgvideoresolution.cpp \
						$$MEDIASVC_SRC_PATH/mgmediacontainer.cpp \
						$$MEDIASVC_SRC_PATH/mqueryobserver.cpp \
						$$MEDIASVC_SRC_PATH/mediainfo.cpp \
						$$MEDIASVC_SRC_PATH/mgmusiccollection.cpp \
						$$MEDIASVC_SRC_PATH/asyncrequestobserver.cpp \
						$$MEDIASVC_SRC_PATH/qmediaservice.cpp \
				./qmediaserviceplugin.cpp \
				$$MEDIASVC_SRC_PATH/qmediagetlistiterator.cpp
}
maemo{
  maemo5 {
    CONFIG(debug):MEDIASVC_SRC_PATH = ./platform/maemo5/
    CONFIG(debug):MEDIASVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):MEDIASVC_SRC_PATH = ./platform/maemo5/
    CONFIG(release):MEDIASVC_INC_PATH = ./platform/maemo5/
    HEADERS = ./qmediaserviceinterface.h \
        ./qmediaserviceplugin.h \
        $$MEDIASVC_INC_PATH/qmediaservice.h \
        $$MEDIASVC_INC_PATH/getmedialisttask.h \
        $$MEDIASVC_INC_PATH/qmediagetlistiterator.h \
        $$MEDIASVC_INC_PATH/getthumbnailtask.h \
        $$MEDIASVC_INC_PATH/mediafilter.h \
        $$MEDIASVC_INC_PATH/mediacontenthelper.h \
        $$MEDIASVC_INC_PATH/resizeimagetask.h \
        $$MEDIASVC_INC_PATH/qmediakeyconstants.h \
        $$MEDIASVC_INC_PATH/qmediaerrorcodes.h \
        $$MEDIASVC_INC_PATH/rdfselect.h \
        $$MEDIASVC_INC_PATH/msselect.h \
        $$MEDIASVC_INC_PATH/thumbnailerfetch.h \
        $$MEDIASVC_INC_PATH/addmusichandler.h
    SOURCES = $$MEDIASVC_SRC_PATH/qmediaservice.cpp \
        $$MEDIASVC_SRC_PATH/qmediagetlistiterator.cpp \
        $$MEDIASVC_SRC_PATH/getmedialisttask.cpp \
        $$MEDIASVC_SRC_PATH/getthumbnailtask.cpp \
        $$MEDIASVC_SRC_PATH/resizeimagetask.cpp \
        $$MEDIASVC_SRC_PATH/mediafilter.cpp \
        $$MEDIASVC_SRC_PATH/mediacontenthelper.cpp \
        ./qmediaserviceplugin.cpp \
        $$MEDIASVC_SRC_PATH/rdfselect.cpp \
        $$MEDIASVC_SRC_PATH/msselect.cpp \
        $$MEDIASVC_SRC_PATH/thumbnailerfetch.cpp \
        $$MEDIASVC_SRC_PATH/addmusichandler.cpp
  }

  else {
    DEFINES += __MAEMO__
	CONFIG(debug):MEDIASVC_SRC_PATH = ./platform/maemo/
	CONFIG(debug):MEDIASVC_INC_PATH = ./platform/maemo/
	CONFIG(release):MEDIASVC_SRC_PATH = ./platform/maemo/
	CONFIG(release):MEDIASVC_INC_PATH = ./platform/maemo/
	
	HEADERS = \
						./qmediaserviceinterface.h \
						./qmediaserviceplugin.h \
						$$MEDIASVC_INC_PATH/qmediaservice.h \
						$$MEDIASVC_INC_PATH/getmedialisttask.h \
						$$MEDIASVC_INC_PATH/qmediagetlistiterator.h \
						$$MEDIASVC_INC_PATH/getthumbnailtask.h \
						$$MEDIASVC_INC_PATH/mediafilter.h \
						$$MEDIASVC_INC_PATH/tagadapter.h \
						$$MEDIASVC_INC_PATH/addmusichandler.h \
						$$MEDIASVC_INC_PATH/mediacontenthelper.h \
						$$MEDIASVC_INC_PATH/resizeimagetask.h

	SOURCES = \
						$$MEDIASVC_SRC_PATH/qmediaservice.cpp \
						$$MEDIASVC_SRC_PATH/qmediagetlistiterator.cpp \
						$$MEDIASVC_SRC_PATH/getmedialisttask.cpp \
						$$MEDIASVC_SRC_PATH/getthumbnailtask.cpp \
						$$MEDIASVC_SRC_PATH/resizeimagetask.cpp \
						$$MEDIASVC_SRC_PATH/mediafilter.cpp \
						$$MEDIASVC_SRC_PATH/tagadapter.cpp \
						$$MEDIASVC_SRC_PATH/addmusichandler.cpp \
						$$MEDIASVC_SRC_PATH/mediacontenthelper.cpp \
						./qmediaserviceplugin.cpp
   }
}


TARGET = WrtApiMedia
include(../cwrtservice.pri)

symbian { 
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x20026157
    LIBS += -lefsrv \
        -lplatformenv \
        -leuser \
        -lestor \
        -lestlib \
        -lcntmodel \
        -lthumbnailmanager \
        -limageconversion \
        -lfbscli \
        -lmediaclientvideo \
        -lws32 \
        -lcone \
        -lapgrfx \
        -lapmime \
        -lmdeclient \
        -lflogger \
        -lmpxcollectionhelper \
           
    VERSION = 3.0.0
    
    TARGET.sources = ./descriptionxml/mediaserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
  #  QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}

maemo {
  maemo5 {
    LIBS += -L$$MAEMO_HOME/maemowrt
    LIBS += -lgio-2.0
    LIBS += -lglib-2.0
    LIBS += -ldbus-glib-1
    LIBS += -ldbus-1

    LIBS += -lmafw
    LIBS += -lmafw-shared
    LIBS += -lpthread
    LIBS += -lgobject-2.0

    LIBS += -lhildonthumbnail
    LIBS += -lgdk_pixbuf-2.0
    LIBS += -lgmodule-2.0
    LIBS += -L/usr/lib/cwrt

    QT += dbus
    INCLUDEPATH += $$CWRT_INCLUDE \
        $$MAEMO_HOME/services \
        $$MAEMO_HOME/utils \
        $$MEDIASVC_SRC_PATH \
        /usr/include/qt4/ \
        /usr/include/qt4/QtCore \
        /usr/include/glib-2.0 \
        /usr/lib/glib-2.0/include

    INCLUDEPATH += /usr/include
    INCLUDEPATH += /usr/include/dbus-1.0
    INCLUDEPATH += /usr/lib/dbus-1.0/include
    INCLUDEPATH += /usr/include/gtk-2.0

    INCLUDEPATH += /usr/include/mafw-1.0 
    INCLUDEPATH += /usr/include/hildon-thumbnail

    INCLUDEPATH += /usr/include/cwrt/security
    INCLUDEPATH += /usr/include/cwrt/servicefw

  }
  else {
    LIBS += -lduithumbnailer
    LIBS += -lqttracker
    LIBS += -lgio-2.0
    LIBS += -lglib-2.0
#    LIBS += -lmusicsuiteinterface
    INCLUDEPATH += $$CWRT_INCLUDE \
        $$MEDIASVC_SRC_PATH \
        /usr/include/qt4/ \
        /usr/include/qt4/QtCore \
        /usr/include/glib-2.0 \
        /usr/lib/glib-2.0/include \
        /usr/include/QtTracker/ \
        /usr/include/QtTracker/ontologies

#    INCLUDEPATH += /usr/include/cwrt/wrt/security
#    INCLUDEPATH += /usr/include/cwrt/servicefw
#        /usr/include/musicsuite-service
#        /usr/include/dui/

    INCLUDEPATH    += ../../inc

   }

    # Export description file
    EXPORT_FILE_NAME_BASE = mediaserviceplugin

    EXPORT_DIR = $$DESTDIR/import/
    EXPORT_SRC = descriptionxml/$$EXPORT_FILE_NAME_BASE.xml
    EXPORT_DST = $$EXPORT_DIR$$EXPORT_FILE_NAME_BASE.xml
    export_files_cmd.input = $$EXPORT_SRC
    export_files_cmd.output = $$EXPORT_DST
    export_files_cmd.commands = $(COPY) $$EXPORT_SRC $$EXPORT_DST
    export_files_cmd.CONFIG = target_predeps no_link
    export_files_cmd.clean = $$EXPORT_DST
    QMAKE_EXTRA_COMPILERS += export_files_cmd
}

