/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef THUMBNAILERFETCH_H
#define THUMBNAILERFETCH_H


#include <QUrl>
#include <QString>



class ThumbnailerFetch : public QObject
{
    Q_OBJECT
public:
    ThumbnailerFetch();
    ~ThumbnailerFetch();

    //request for new thumbnail for url from urlList
    void request(const QList<QUrl> &urlList,const QStringList &mimetypes, int height, int width,  bool isCropped=true);

protected slots:
    //slots for signals from thumbnailer
    void onThumbError(quint32 thumbTransactId, const QStringList& description, qint32 errorValue, const QString& qq);
    void onThumbFinished(quint32 thumbTransactId);

private:
    unsigned int m_lastThumbTransactId;
    QUrl m_thumbnailPath;
    QList<QUrl> m_sourcesPaths;
    QUrl m_sourcePath;
    bool isConnect;
Q_SIGNALS:
    void error(const QString&, const QUrl&);
    void thumbnail(const QUrl&, const QUrl&, const QString&);

};

#endif // THUMBNAILERFETCH_H
