/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#include <QDateTime>

#include "qmediagetlistiterator.h"
#include "qmediakeyconstants.h"


/**
* C++ constructor
* @param mediaService Media core class object pointer
* @param mediaIdList Media object Id list
* @return none
*/
QMediaGetListIterator::QMediaGetListIterator(QVariantList aList)
    : iList (aList)
{
    iIterator = new QListIterator<QVariant>(iList);
}

/**
* Resets the iterator
* @return none
*/
void QMediaGetListIterator::reset()
{
    delete iIterator;
    iIterator = new QListIterator<QVariant>(iList);
}


QMediaGetListIterator::~QMediaGetListIterator()
{
    delete iIterator;
}

bool QMediaGetListIterator::hasNext()
{
    return iIterator->hasNext();
}

/**
* Get current item in the collection and get ready for next item.
*
* @return current data entry
* 
*/
QVariant QMediaGetListIterator::next()
{
    if (iIterator->hasNext())
    {
        return iIterator->next();
    }
    return NULL;
}

void QMediaGetListIterator::close()
{
}

