/*
* ============================================================================
*  Name        : qlocationserviceplugin.h
*  Part of     : serviceframework / WRT
*  Description : Qt plugin class for test service
*  Version     : %version: 15 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef LOCATIONPLUGIN_H_
#define LOCATIONPLUGIN_H_

//System Include
#include <QObject>
#include <QMap>
#ifndef __MAEMO__
#include <QPlugin.h>
#else
#include <QtCore>
#endif

//User Include
#include "serviceplugininterface.h"
#include "service.h"
#include "qlocationservice.h"


/**
 * Location service Plugin class
 * @lib locationplugin.lib
 * @since x.y
 */
class LocationPlugin : public QObject, IServicePlugin
{
    Q_OBJECT

    Q_INTERFACES(IServicePlugin)

public:
    /**
     * Default constructor
     * @return none
     * @since x.y
     */
    LocationPlugin();

    /**
     * Destructor
     * @return none
     * @since x.y
     */
    virtual ~LocationPlugin();

protected: // inherited method
    /**
     * Return IServiceBase pointer to service object which provide the service
     * to clients of service framework.
     * @param refCounted true interface is reference counted
     * @param secSession Security Manager session - not owned
     * @return the interface pointer to service object. The ownership of the
     * service object is transferred.
     * @since x.y
     */
    IServiceBase* getServiceBase(bool refCounted, WRT::SecSession *secSession);
};

#endif //LOCATIONPLUGIN_H_
