/*
* ============================================================================
*  Name        : emitAsyncTask.h
*  Part of     : serviceframework / WRT
*  Description : Qt class for Location service
*  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef EMITASYNCTASK_H_
#define EMITASYNCTASK_H_

#include <QObject>
#include <QRunnable>
#include <QMap>
#include <QVariant>

// This object is created for emitting asyncronous signal.

class asyncTask: public QObject, public QRunnable {
    Q_OBJECT

public:
    asyncTask(int errStatus, qint32 transaction_id, QMap<QString, QVariant> aMap);
    virtual ~asyncTask();
    virtual void run();

signals:
    void asyncCB(int errStatus, qint32 transId, QMap<QString, QVariant> retMap);

private:
    int errStatus;
    qint32 m_trId;
    QMap<QString, QVariant> retMap;
};

#endif // EMITASYNCTASK_H
