/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef UTILITIES_H_
#define UTILITIES_H_

#include <QMap>
#include <QVariant>

//data not set
const int DATA_NOT_SET = -1;

typedef QMap<QString,QVariant> FileSystemMap;

class Utilities
    {
public:
    Utilities();
    virtual ~Utilities();
    static FileSystemMap ReturnMap(int errorCode,
            QString errorMessage,
            QVariant data = DATA_NOT_SET);

    };

#endif /* UTILITIES_H_ */
