/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtTest/QtTest>
#include <QtCore>
#include "referenceservice.h"
#include "service.h"

class ReferenceServiceTest: public QObject
{
    Q_OBJECT

public slots:
    void testIntAsyncCallback(int ret);

private slots:
    void initTestCase();
    void testMapSync();
    void testListSync();
    void testIntAsync();

private:
    ServiceSingleton<ReferenceService>* so;
    int iInt;
};

void ReferenceServiceTest::initTestCase()
{
    so = new ServiceSingleton<ReferenceService>();
    connect(so, SIGNAL(testIntAsyncCallback(int)),
        this, SLOT(testIntAsyncCallback(int)));
}

void ReferenceServiceTest::testMapSync()
{
    QVariantMap map;
    map["int"] = 12345;
    map["string"] = "Hello World";
    QCOMPARE(map, so->testMapSync(map).toMap());
}

void ReferenceServiceTest::testListSync()
{
    QVariantList list;
    list.append(12345);
    list.append("Hello World");
    QCOMPARE(list, so->testListSync(list).toList());
}

void ReferenceServiceTest::testIntAsync()
{
    iInt = 12345;
    so->testIntAsync(iInt);
}

void ReferenceServiceTest::testIntAsyncCallback(int ret)
{
    QCOMPARE(ret, iInt);
}

QTEST_MAIN(ReferenceServiceTest)
#include "referenceservicetest.moc"
