# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin
!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}
symbian {
    CONFIG(debug):CONTACTSVC_SRC_PATH = ./platform/s60/
    CONFIG(debug):CONTACTSVC_INC_PATH = ./platform/s60/
    CONFIG(release):CONTACTSVC_SRC_PATH = ./platform/s60/
    CONFIG(release):CONTACTSVC_INC_PATH = ./platform/s60/
    HEADERS = $$CONTACTSVC_INC_PATH/addcontactobserver.h \
                    $$CONTACTSVC_INC_PATH/cancelasyncrquest.h \
                    $$CONTACTSVC_INC_PATH/contactcallback.h \
                    $$CONTACTSVC_INC_PATH/contactiter.h \
                    $$CONTACTSVC_INC_PATH/contactretrieveobserver.h \
                    $$CONTACTSVC_INC_PATH/contactservice.h \
                    $$CONTACTSVC_INC_PATH/contactservice.hrh \
                    $$CONTACTSVC_INC_PATH/contactsynccallback.h \
                    $$CONTACTSVC_INC_PATH/contactviewobserver.h \
                    $$CONTACTSVC_INC_PATH/deletecontactobserver.h \
                    $$CONTACTSVC_INC_PATH/exportstorelistobserver.h \
                    $$CONTACTSVC_INC_PATH/fieldkeys.hrh \
                    $$CONTACTSVC_INC_PATH/getliststorelistobserver.h \
                    $$CONTACTSVC_INC_PATH/importstorelistobserver.h \
                    $$CONTACTSVC_INC_PATH/organisegroupsobserver.h \
                    $$CONTACTSVC_INC_PATH/notificationobserver.h \
                    $$CONTACTSVC_INC_PATH/searchfields.h \
                    $$CONTACTSVC_INC_PATH/singlecontact.h \
                    $$CONTACTSVC_INC_PATH/singlecontactfield.h \
                    $$CONTACTSVC_INC_PATH/storelistobserver.h \
                    $$CONTACTSVC_INC_PATH/syncbehaviour.h \
                    $$CONTACTSVC_INC_PATH/qcontactservice.h \
                $$CONTACTSVC_INC_PATH/qcontactsiterator.h \
                $$CONTACTSVC_INC_PATH/qcontactData.h \
                    ./qcontactserviceplugin.h \
                ./qcontactserviceinterface.h

    SOURCES = $$CONTACTSVC_SRC_PATH/contactservice.cpp  \
                    $$CONTACTSVC_SRC_PATH/importstorelistobserver.cpp   \
                    $$CONTACTSVC_SRC_PATH/exportstorelistobserver.cpp   \
                    $$CONTACTSVC_SRC_PATH/syncbehaviour.cpp  \
                    $$CONTACTSVC_SRC_PATH/getliststorelistobserver.cpp  \
                    $$CONTACTSVC_SRC_PATH/contactviewobserver.cpp  \
                    $$CONTACTSVC_SRC_PATH/contactretrieveobserver.cpp  \
                    $$CONTACTSVC_SRC_PATH/notificationobserver.cpp \
                    $$CONTACTSVC_SRC_PATH/contactiter.cpp  \
                    $$CONTACTSVC_SRC_PATH/searchfields.cpp  \
                    $$CONTACTSVC_SRC_PATH/singlecontact.cpp  \
                    $$CONTACTSVC_SRC_PATH/singlecontactfield.cpp  \
                    $$CONTACTSVC_SRC_PATH/contactsynccallback.cpp  \
                    $$CONTACTSVC_SRC_PATH/contactsyncapi.cpp  \
                    $$CONTACTSVC_SRC_PATH/addcontactobserver.cpp   \
                    $$CONTACTSVC_SRC_PATH/deletecontactobserver.cpp   \
                    $$CONTACTSVC_SRC_PATH/organisegroupsobserver.cpp  \
                    $$CONTACTSVC_SRC_PATH/qcontactsiterator.cpp \
                  $$CONTACTSVC_SRC_PATH/qcontactservice.cpp \
                $$CONTACTSVC_SRC_PATH/qcontactData.cpp \
                                ./qcontactserviceplugin.cpp
}

maemo {
    CONFIG(debug):CONTACTSVC_SRC_PATH = ./platform/maemo/
    CONFIG(debug):CONTACTSVC_INC_PATH = ./platform/maemo/
    CONFIG(release):CONTACTSVC_SRC_PATH = ./platform/maemo/
    CONFIG(release):CONTACTSVC_INC_PATH = ./platform/maemo/

    HEADERS = $$CONTACTSVC_INC_PATH/qcontactserviceplugin.h \
    $$CONTACTSVC_INC_PATH/qcontactserviceinterface.h \
    $$CONTACTSVC_INC_PATH/qcontactservice.h

    SOURCES = $$CONTACTSVC_SRC_PATH/qcontactserviceplugin.cpp \
    $$CONTACTSVC_SRC_PATH/qcontactservice.cpp
}

maemo {
    TARGET = WrtApiContact
} else {
    TARGET = contactserviceplugin
}
include(../cwrtservice.pri)

INCLUDEPATH += $$CWRT_INCLUDE

symbian {
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x2002614D
    LIBS += -lefsrv \
        -lplatformenv \
        -lvpbkeng \
        -lvpbkvcardEng \
        -lestor \
        -lcone \
        -leikcore \
        -lavkon \
        -lcommonengine \
        -lbafl \
        -lCentralRepository \
        -lapgrfx \
        -lapparc \
        -lws32  \
        -lPbk2Presentation

      VERSION = 3.0.0

    TARGET.sources = ./descriptionxml/contactserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
  #  QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}

maemo {
    maemo5 {
        DEFINES += __MAEMO5__
        QT += dbus
        LIBS += -lQtContacts
        LIBS -= -lsecmgr
        LIBS += -L/usr/lib -lWrtSecurityManager

        CONFIG += mobility
        MOBILITY +=contacts

        INCLUDEPATH += $$CWRT_INCLUDE
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    } else {
        LIBS += -lmaemomeegotouchcontactsinterface
        LIBS += -lQtContacts

        CONFIG += mobility
        MOBILITY +=contacts

        INCLUDEPATH += $$CWRT_INCLUDE \
                       /usr/include/qt4/QtContacts \
                       /usr/include/maemo-meegotouch-interfaces
    }
    SOURCES += $$CONTACTSVC_SRC_PATH/qgetcontactstask.cpp \
            $$CONTACTSVC_SRC_PATH/qgetgroupstask.cpp\
            $$CONTACTSVC_SRC_PATH/qgetcontactidstask.cpp \
            $$CONTACTSVC_SRC_PATH/qgetgroupidstask.cpp \
            $$CONTACTSVC_SRC_PATH/qcontactshelpers.cpp \
            $$CONTACTSVC_SRC_PATH/qjsonizer.cpp \
            $$CONTACTSVC_SRC_PATH/qgroupsiterator.cpp \
            $$CONTACTSVC_SRC_PATH/qcontactsiterator.cpp

    HEADERS += $$CONTACTSVC_INC_PATH/qgetcontactstask.h \
            $$CONTACTSVC_INC_PATH/qgetgroupstask.h \
            $$CONTACTSVC_INC_PATH/qgetcontactidstask.h \
            $$CONTACTSVC_INC_PATH/qgetgroupidstask.h \
            $$CONTACTSVC_INC_PATH/qcontactshelpers.h \
            $$CONTACTSVC_INC_PATH/qjsonizer.h \
            $$CONTACTSVC_INC_PATH/qgroupsiterator.h \
            $$CONTACTSVC_INC_PATH/qcontactsiterator.h
}
