/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef JSONIZER_HH
#define JSONIZER_HH
#include <QString>
#include <QVariant>
#include <QVector>
#include <QMap>
#include <qtcontacts.h>

using namespace QTM_NAMESPACE;

class JSonizer{
public:

    JSonizer();
    ~JSonizer();

    QVariant contact2json(const QContact *contact);
    /**
    * Helpers for transferring the contact to map.
    */
    void nameFields2json(const QContact * contact);
    void telFields2json(const QContact * contact);
    void addressFields2json(const QContact * contact);
    void companyFields2json(const QContact * contact);
    void miscFields2json(const QContact * contact);
    void cleanContactMap(QMap<QString,QVariant>* dataMap);
    bool isValueEmptyOrNull(QVariant value);

private:
    QMap<QString,QVariant> m_contactMap;

};
#endif

