/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QStringList>
#include <QMapIterator>
#include <QMap>
#include <QtDebug>
#include "qgetgroupstask.h"
#include "qcontactshelpers.h"

GetGroupsTask::GetGroupsTask(qint32 trId) :
    m_trId(trId) {
}

GetGroupsTask::~GetGroupsTask()
{
}

void GetGroupsTask::run()
{
    // Getting groups via QtContacts
    QContactManager* cm = new QContactManager();
    QList<QContact> groupList;
    QContactDetailFilter groupFilter;
    groupFilter.setDetailDefinitionName(QContactType::DefinitionName, QContactType::FieldType);
    groupFilter.setValue(QString(QLatin1String(QContactType::TypeGroup)));

    QContactFetchRequest* fetch = new QContactFetchRequest;

    fetch->setFilter(groupFilter);
    fetch->setManager(cm);

    iMutex.lock();

    if (!fetch->start()) {
        qDebug() << "Failed to start group fetch request!";
        // Start failed
        emit groupInfos(this, groupList, m_trId,
                CJSEStatusCodes::DATA_NOT_FOUND_ERR);
    } else {
        qDebug() << "Get group request started...";
        fetch->waitForFinished();
        qDebug() << "Get group request end";

        groupList = fetch->contacts();
        qDebug() << "Number of groups: " <<  groupList.count();

        if (groupList.isEmpty()) {
            emit groupInfos(this, groupList, m_trId, CJSEStatusCodes::DATA_NOT_FOUND_ERR);
        } else {
            emit groupInfos(this, groupList, m_trId, CJSEStatusCodes::SUCCESS);
        }
    }

    iMutex2.lock();
    iMutex.unlock();
    iWait.wait(&iMutex2);
    iMutex2.unlock();
}

void GetGroupsTask::finishTask()
{
    iMutex.lock();
    iMutex.unlock();
    // Release mutex
    iWait.wakeAll();
}

