/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "qgetgroupidstask.h"
#include "qcontactshelpers.h"
#include <QtDebug>
#include <QStringList>

GetGroupIdsTask::GetGroupIdsTask(qint32 trId) :
    m_trId(trId)
{
}

GetGroupIdsTask::~GetGroupIdsTask()
{
}

void GetGroupIdsTask::run()
{
    // Getting contacts via QtContacts
    QContactManager* cm = new QContactManager();
    QList<QContactLocalId> idList;
    QList<QContact> groupList;
    QContactDetailFilter groupFilter;
    groupFilter.setDetailDefinitionName(QContactType::DefinitionName, QContactType::FieldType);
    groupFilter.setValue(QString(QLatin1String(QContactType::TypeGroup)));

    QContactFetchRequest* fetch = new QContactFetchRequest;

    fetch->setFilter(groupFilter);
    fetch->setManager(cm);

    iMutex.lock();

    if (!fetch->start()) {
        qDebug() << "Failed to start group id fetch request!";
        // Start failed
        emit groupIds(this, idList, m_trId,
            CJSEStatusCodes::DATA_NOT_FOUND_ERR);
    } else {
        qDebug() << "Get group id request started...";
        fetch->waitForFinished();
        qDebug() << "Get group id request end";

        groupList = fetch->contacts();
        qDebug() << "Number of groups: " <<  groupList.count();

        for (int index = 0 ; index < groupList.count() ; index++) {
            idList.append(groupList[index].id().localId());
        }

        if (idList.isEmpty()) {
            emit groupIds(this, idList, m_trId, CJSEStatusCodes::DATA_NOT_FOUND_ERR);
        } else {
            emit groupIds(this, idList, m_trId, CJSEStatusCodes::SUCCESS);
        }
    }

    iMutex2.lock();
    iMutex.unlock();
    iWait.wait(&iMutex2);
    iMutex2.unlock();
}

void GetGroupIdsTask::finishTask()
{
    iMutex.lock();
    iMutex.unlock();
    // Release mutex
    iWait.wakeAll();
}

