/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtDebug>

#include "qgetcontactstask.h"
#include "qjsonizer.h"
#include "qcontactshelpers.h"

GetContactsTask::GetContactsTask(QString match,
        qint32 sortOrder, qint32 trId) :
    m_match(match), m_sortOrder(sortOrder), m_trId(trId)
{
}

GetContactsTask::~GetContactsTask()
{
}

void GetContactsTask::run()
{
    // Requesting Contacts from backend
    QContactManager* cm = new QContactManager();
    QContactFetchRequest* fetch = new QContactFetchRequest;
    fetch->setManager(cm);
    QStringList details;
    QList<QContact> contactList;
    details << QContactName::DefinitionName;

    QContactSortOrder order1, order2;
    QList<QContactSortOrder> sortOrders;
    order1.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldLastName);
    order2.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldFirstName);

    if (m_sortOrder == 0) {
        order1.setDirection(Qt::AscendingOrder);
    } else if (m_sortOrder == 1) {
        order1.setDirection(Qt::DescendingOrder);
    }

    sortOrders << order1 << order2;
    //fetch->setDefinitionRestrictions(details);
    fetch->setSorting(sortOrders);

    if (!m_match.isEmpty()) {
        QContactUnionFilter union_filter;
        QContactDetailFilter filter1, filter2;
        filter1.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldLastName);
        filter2.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldFirstName);
        filter1.setMatchFlags(QContactFilter::MatchContains);
        filter2.setMatchFlags(QContactFilter::MatchContains);
        filter1.setValue(m_match);
        filter2.setValue(m_match);

        union_filter << filter1 << filter2;
        // Request subset
        fetch->setFilter(union_filter);
    }

    iMutex.lock();

    if (!fetch->start()) {
        qDebug() << "Failed to start contact fetch request!";
        // Start failed
        emit contactObjects(this, contactList, m_trId,
                    CJSEStatusCodes::DATA_NOT_FOUND_ERR);
    } else {
        qDebug() << "Get contact request started...";
        fetch->waitForFinished();
        qDebug() << "Get contact request end";

        contactList = fetch->contacts();
        qDebug() << "Number of contacts: " <<  contactList.count();

        if (contactList.isEmpty()) {
            emit contactObjects(this, contactList, m_trId,
                    CJSEStatusCodes::DATA_NOT_FOUND_ERR);
        } else {
            emit contactObjects(this, contactList, m_trId,
                    CJSEStatusCodes::SUCCESS);
        }
    }

    iMutex2.lock();
    iMutex.unlock();
    iWait.wait(&iMutex2);
    iMutex2.unlock();
}

void GetContactsTask::finishTask()
{
    iMutex.lock();
    iMutex.unlock();
    // Release mutex
    iWait.wakeAll();
}

