/*
* ============================================================================
*  Name        : QContactsIterator.cpp
*  Part of     : serviceframework / WRT
*  Description : Qt Iterator for contacts
*  Version     : %version: 6 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#include "qcontactsiterator.h"
#include "qjsonizer.h"

/**
 * The intention is to use the same iterator class for contacts, groups, contactIds and groupIDs.
 * One of the following enum values are needed for this class instantiation.
 */

//Map keys for QT Group Data Structure
/*const QString KGroupId = "groupId";
const QString KGroupLabel = "groupName";
const QString KGroup = "group";
const QString KContents = "contents";
*/


QContactsIterator::QContactsIterator(QList<QContact> aContacts):iContactIter(aContacts)
{
    iHasNext = true;
}

QContactsIterator::~QContactsIterator()
{

}

void QContactsIterator::reset()
{

}

bool QContactsIterator::hasNext()
{
    return iHasNext;
}

QVariant QContactsIterator::next()
{
    QVariant var=NULL;

    if (!iContactIter.hasNext()) {
        iHasNext = false;
    }

    if (iHasNext) {
        QContact contact = iContactIter.next();
        JSonizer conv;
        var = conv.contact2json(&contact);
    } else {
        var = NULL;
        iHasNext = false;
    }

    //qDebug() << "var: " << var;
    return var;
}

void QContactsIterator::close()
{

}


