/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QDebug>
#include <QString>
#include <QStringList>

#include "qcontactservice.h"
#include "qjsonizer.h"
#include "qcontactshelpers.h"


namespace ContactsHelpers {

    QVariant createGroupInfoJSON(const QContact *group)
    {
        QVariant retVar = NULL;

        // Insert to map
        QMap<QString,QVariant> valueMap;
        QMap<QString,QVariant> tmpMap;

        tmpMap.insert("groupId",QVariant(group->id().localId()));
        tmpMap.insert("groupName",QVariant(group->displayLabel()));

        valueMap.insert("group",QVariant(tmpMap));

        QList<QVariant> memberList;
        QContactManager* cm = new QContactManager();
        //QList<QUniqueId> tmpList(group->members());
        QContactId grpId;
        grpId.setLocalId(group->id().localId());
        QList<QContactRelationship> tmpList = cm->relationships(QContactRelationship::HasMember, grpId);

        foreach (const QContactRelationship& currRel, tmpList) {
            memberList.append(currRel.second().localId());
        }

        valueMap.insert("contents",QVariant(memberList));

        retVar = valueMap;

        return retVar;
    }

    void setContactFields(QContact * con,
            const QMap<QString, QVariant> & jsonObject)
    {
        QMapIterator<QString, QVariant> iterator(jsonObject);
        while (iterator.hasNext()) {
            iterator.next();
            setContactField(con, iterator.key(), iterator.value());
        }
    }

    void setContactField(QContact* con, QString key, QVariant data)
    {
        //qDebug() << "setContactField key: " << key << " data: " << data;

        if (key == "name") {
            QContactName name;
            QMap<QString, QVariant> nameMap = data.toMap();
            QMapIterator<QString, QVariant> name_iter(nameMap);
            while (name_iter.hasNext()) {
                name_iter.next();
                if (name_iter.key() == "last") {
                    name.setLastName(name_iter.value().toString());
                } else if (name_iter.key() == "first") {
                    name.setFirstName(name_iter.value().toString());
                } else if (name_iter.key() == "middle") {
                    name.setMiddleName(name_iter.value().toString());
                } else if (name_iter.key() == "suffix") {
                    name.setSuffix(name_iter.value().toString());
                } else if (name_iter.key() == "prefix") {
                    name.setPrefix(name_iter.value().toString());
                }
            }

            con->saveDetail(&name);
        } else if (key == "tel") {
            QContactPhoneNumber tel;
            QContactPhoneNumber tel2;
            QContactPhoneNumber tel3;
            QMap<QString, QVariant> telMap = data.toMap();
            QMapIterator<QString, QVariant> tel_iter(telMap);
            while (tel_iter.hasNext()) {
                tel_iter.next();
                if (tel_iter.key() == "land") {
                    tel.setSubTypes(QContactPhoneNumber::SubTypeLandline);
                    tel.setNumber(tel_iter.value().toString());
                } else if (tel_iter.key() == "mobile") {
                    tel.setSubTypes(QContactPhoneNumber::SubTypeMobile);
                    tel.setNumber(tel_iter.value().toString());
                } else if (tel_iter.key() == "fax") {
                    tel.setSubTypes(QContactPhoneNumber::SubTypeModem);
                    tel.setNumber(tel_iter.value().toString());
                } else if (tel_iter.key() == "voip") {
                    tel.setSubTypes(QContactPhoneNumber::SubTypeVoice);
                    tel.setNumber(tel_iter.value().toString());
                } else if (tel_iter.key() == "video") {
                    tel.setSubTypes(QContactPhoneNumber::SubTypeVideo);
                    tel.setNumber(tel_iter.value().toString());
                } else if (tel_iter.key() == "work") { // Work
                    tel2.setContexts(QContactPhoneNumber::ContextWork);
                    QMap<QString, QVariant> workMap = tel_iter.value().toMap();
                    QMapIterator<QString, QVariant> work_iter(workMap);
                    while (work_iter.hasNext()) {
                        work_iter.next();
                        if (work_iter.key() == "land") {
                            tel2.setSubTypes(QContactPhoneNumber::SubTypeLandline);
                            tel2.setNumber(work_iter.value().toString());
                        } else if (work_iter.key() == "mobile") {
                            tel2.setSubTypes(QContactPhoneNumber::SubTypeMobile);
                            tel2.setNumber(work_iter.value().toString());
                        } else if (work_iter.key() == "fax") {
                            tel2.setSubTypes(QContactPhoneNumber::SubTypeModem);
                            tel2.setNumber(work_iter.value().toString());
                        } else if (work_iter.key() == "voip") {
                            tel2.setSubTypes(QContactPhoneNumber::SubTypeVoice);
                            tel2.setNumber(work_iter.value().toString());
                        } else if (work_iter.key() == "video") {
                            tel2.setSubTypes(QContactPhoneNumber::SubTypeVideo);
                            tel2.setNumber(work_iter.value().toString());
                        }
                    }
                } else if (tel_iter.key() == "home") { // Home
                    tel3.setContexts(QContactPhoneNumber::ContextHome);
                    QMap<QString, QVariant> homeMap = tel_iter.value().toMap();
                    QMapIterator<QString, QVariant> home_iter(homeMap);
                    while (home_iter.hasNext()) {
                        home_iter.next();
                        if (home_iter.key() == "land") {
                            tel3.setSubTypes(QContactPhoneNumber::SubTypeLandline);
                            tel3.setNumber(home_iter.value().toString());
                        } else if (home_iter.key() == "mobile") {
                            tel3.setSubTypes(QContactPhoneNumber::SubTypeMobile);
                            tel3.setNumber(home_iter.value().toString());
                        } else if (home_iter.key() == "fax") {
                            tel3.setSubTypes(QContactPhoneNumber::SubTypeModem);
                            tel3.setNumber(home_iter.value().toString());
                        } else if (home_iter.key() == "voip") {
                            tel3.setSubTypes(QContactPhoneNumber::SubTypeVoice);
                            tel3.setNumber(home_iter.value().toString());
                        } else if (home_iter.key() == "video") {
                            tel3.setSubTypes(QContactPhoneNumber::SubTypeVideo);
                            tel3.setNumber(home_iter.value().toString());
                        }
                    }
                }
            }

            con->saveDetail(&tel);
            con->saveDetail(&tel2);
            con->saveDetail(&tel3);
        } else if (key == "address") {
            QContactAddress address;
            QContactEmailAddress email;
            QContactUrl url;
            QContactAddress address2;
            QContactEmailAddress email2;
            QContactUrl url2;
            QContactAddress address3;
            QContactEmailAddress email3;
            QContactUrl url3;
            QMap<QString, QVariant> addressMap = data.toMap();
            QMapIterator<QString, QVariant> address_iter(addressMap);
            while (address_iter.hasNext()) {
                address_iter.next();
                if (address_iter.key() == "street") {
                    address.setStreet(address_iter.value().toString());
                } else if (address_iter.key() == "local") {
                    address.setLocality(address_iter.value().toString());
                } else if (address_iter.key() == "region") {
                    address.setRegion(address_iter.value().toString());
                } else if (address_iter.key() == "code") {
                    address.setPostcode(address_iter.value().toString());
                } else if (address_iter.key() == "country") {
                    address.setCountry(address_iter.value().toString());
                } else if (address_iter.key() == "email") {
                    email.setEmailAddress(address_iter.value().toString());
                } else if (address_iter.key() == "uri") {
                    url.setUrl(address_iter.value().toString());
                } else if (address_iter.key() == "work") { // Work
                    address2.setContexts(QContactAddress::ContextWork);
                    QMap<QString, QVariant> workaddrMap = address_iter.value().toMap();
                    QMapIterator<QString, QVariant> workaddr_iter(workaddrMap);
                    while (workaddr_iter.hasNext()) {
                        workaddr_iter.next();
                        if (workaddr_iter.key() == "street") {
                            address2.setStreet(workaddr_iter.value().toString());
                        } else if (workaddr_iter.key() == "local") {
                            address2.setLocality(workaddr_iter.value().toString());
                        } else if (workaddr_iter.key() == "region") {
                            address2.setRegion(workaddr_iter.value().toString());
                        } else if (workaddr_iter.key() == "code") {
                            address2.setPostcode(workaddr_iter.value().toString());
                        } else if (address_iter.key() == "country") {
                            address2.setCountry(workaddr_iter.value().toString());
                        } else if (workaddr_iter.key() == "email") {
                            email2.setContexts(QContactEmailAddress::ContextWork);
                            email2.setEmailAddress(workaddr_iter.value().toString());
                        } else if (workaddr_iter.key() == "uri") {
                            url2.setContexts(QContactUrl::ContextWork);
                            url.setUrl(workaddr_iter.value().toString());
                        }
                    }
                } else if (address_iter.key() == "home") { // Home
                    address3.setContexts(QContactAddress::ContextHome);
                    QMap<QString, QVariant> homeaddrMap = address_iter.value().toMap();
                    QMapIterator<QString, QVariant> homeaddr_iter(homeaddrMap);
                    while (homeaddr_iter.hasNext()) {
                        homeaddr_iter.next();
                        if (homeaddr_iter.key() == "street") {
                            address3.setStreet(homeaddr_iter.value().toString());
                        } else if (homeaddr_iter.key() == "local") {
                            address3.setLocality(homeaddr_iter.value().toString());
                        } else if (homeaddr_iter.key() == "region") {
                            address3.setRegion(homeaddr_iter.value().toString());
                        } else if (homeaddr_iter.key() == "code") {
                            address3.setPostcode(homeaddr_iter.value().toString());
                        } else if (homeaddr_iter.key() == "country") {
                            address3.setCountry(homeaddr_iter.value().toString());
                        } else if (homeaddr_iter.key() == "email") {
                            email3.setContexts(QContactEmailAddress::ContextHome);
                            email3.setEmailAddress(homeaddr_iter.value().toString());
                        } else if (homeaddr_iter.key() == "uri") {
                            url3.setContexts(QContactUrl::ContextHome);
                            url3.setUrl(homeaddr_iter.value().toString());
                        }
                    }
                }
            }

            con->saveDetail(&address);
            con->saveDetail(&email);
            con->saveDetail(&url);
            con->saveDetail(&address2);
            con->saveDetail(&email2);
            con->saveDetail(&url2);
            con->saveDetail(&address3);
            con->saveDetail(&email3);
            con->saveDetail(&url3);
        } else if (key == "company") {
            QContactOrganization organization;
            organization.setName(data.toMap().value("name").toString());
            organization.setLogoUrl(QUrl(data.toMap().value("title").toString()));
            con->saveDetail(&organization);
        } else if (key == "id") {
            // Id present if the use case is updateContact
            QContactId cId;
            cId.setLocalId(data.toUInt());
            con->setId(cId);
        } else if (key == "notes") {
            QContactNote notes;
            notes.setNote(data.toString());
            con->saveDetail(&notes);
        } else if (key == "anniversary") {
            QContactAnniversary anniversary;
            QDateTime dateTime(reinterpret_cast<QDateTime&>(data));
            anniversary.setOriginalDate(dateTime.date());
            con->saveDetail(&anniversary);
        } else if (key == "birthday") {
            QContactBirthday birthday;
            QDateTime dateTime(reinterpret_cast<QDateTime&>(data));
            birthday.setDate(dateTime.date());
            con->saveDetail(&birthday);
        } else if (key == "nickname") {
            QContactNickname nickname;
            nickname.setNickname(data.toString());
            con->saveDetail(&nickname);
        } else if (key == "photo") {
            QContactAvatar avatar;
            avatar.setImageUrl(QUrl(data.toString()));
            con->saveDetail(&avatar);
        } else if (key == "displayName") {
            QContactName displayLabel;
            displayLabel.setCustomLabel(QString(data.toString()));
            con->saveDetail(&displayLabel);
        } else if (key == "xspid") {
            // No point to set xspids?
        }
    }

// ContactsHelpers Namespace ends
}

