/*
* ============================================================================
*  Name        : qeventServicePlugin.cpp
*  Part of     : serviceproviders / WRT
*  Description : Qt plugin class for event service
*  Version     : %version: 6 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

//QT includes
#include <QtCore>
#include <QDebug>
#include <QMap>

#include "service.h"

//local includes
#include "qcommlogserviceplugin.h"
#if defined(__MAEMO5__)
#include "./platform/maemo5/qcommlogservice.h"
#else
#include "qcommlogservice.h"
#endif


QCommLogServicePlugin::QCommLogServicePlugin()
{
}

/*!
    Destructor
 */
QCommLogServicePlugin::~QCommLogServicePlugin()
{
}

/*!
    This API is used to instantiate Reference Service service provider

    \param refCounted true reference counted object.
    \param secSession Security Manager session - not owned
    @return interface pointer to Reference Service object
 */
IServiceBase* QCommLogServicePlugin::getServiceBase(bool refCounted,
                                                  WRT::SecSession *secSession)
{
    IServiceBase* pInterface(NULL);
    CREATE_SERVICE_OBJECT(QCommLogService, pInterface, refCounted);
    IServiceSecurity *security=NULL;
    if (refCounted) {
        security = static_cast<IServiceSecurity*>(serviceObject);
    } else  {
        security = static_cast<IServiceSecurity*>(singletonServiceObject);
    }
    security->setSecuritySession(secSession);
    return pInterface;
}

Q_EXPORT_PLUGIN(QCommLogServicePlugin);
