/*
* ============================================================================
*  Name        : qeventinterface.h
*  Part of     : serviceproviders / WRT
*  Description : Interface for event service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QCOMMLOGSERVICEINTERFACE_H
#define QCOMMLOGSERVICEINTERFACE_H

//QT Include
#include <QVariant>
#include <QString>
#include <QMap>

//Service Framework Include
#include "servicebase.h"

static const char* KICommLogId = "com.nokia.ICommLog/1.0";

// ITypeTest interface id.For Future use
static const ServiceInterfaceInfo KICommLogInfo =
{
    KICommLogId, 0
};

class ICommLog : public IServiceBase
{
public:

    virtual QVariant getList ( const QMap<QString, QVariant>& match,  const int& transId ) = 0;

    virtual QObject* getList ( const QMap<QString, QVariant>& match ) = 0;

    virtual QVariant cancel ( const int& transId=-1 ) = 0;

    virtual QVariant setNotification ( const int& transId=-1 ) = 0;

    virtual QVariant cancelNotification ( const int& transId=-1 ) = 0;

    virtual QVariant deleteLogEntry ( const int& logId = -1) = 0;
};
Q_DECLARE_INTERFACE(ICommLog, KICommLogId);

#endif //QCOMMLOGSERVICEINTERFACE_H
