# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin
!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}
symbian { 
	CONFIG(debug):COMMLOGSVC_SRC_PATH = ./platform/s60/
	CONFIG(debug):COMMLOGSVC_INC_PATH = ./platform/s60/
	CONFIG(release):COMMLOGSVC_SRC_PATH = ./platform/s60/
	CONFIG(release):COMMLOGSVC_INC_PATH = ./platform/s60/
	HEADERS = qcommlogserviceinterface.h \
				qcommlogserviceplugin.h \
				$$COMMLOGSVC_INC_PATH/loggingasyncservice.h \
				$$COMMLOGSVC_INC_PATH/loggingsyncservice.h \
				$$COMMLOGSVC_INC_PATH/loggingservice.h \
				$$COMMLOGSVC_INC_PATH/loggingevent.h \
				$$COMMLOGSVC_INC_PATH/loggingfilter.h \
				$$COMMLOGSVC_INC_PATH/loggingcallbackslot.h \
				$$COMMLOGSVC_INC_PATH/logiter.h \
				$$COMMLOGSVC_INC_PATH/qcommlogservice.h \
				$$COMMLOGSVC_INC_PATH/qcommlogiterator.h \
				$$COMMLOGSVC_INC_PATH/qcommlogdata.h \
				$$COMMLOGSVC_INC_PATH/qcommlogerrorcodes.h \
				$$COMMLOGSVC_INC_PATH/qcommlogkeyconstants.h
	
	SOURCES = qcommlogserviceplugin.cpp \
				$$COMMLOGSVC_SRC_PATH/loggingasyncservice.cpp \
				$$COMMLOGSVC_SRC_PATH/loggingsyncservice.cpp \
				$$COMMLOGSVC_SRC_PATH/loggingservice.cpp \
				$$COMMLOGSVC_SRC_PATH/loggingevent.cpp \
				$$COMMLOGSVC_SRC_PATH/loggingfilter.cpp \
				$$COMMLOGSVC_SRC_PATH/loggingcallbackslot.cpp \
				$$COMMLOGSVC_SRC_PATH/logiter.cpp \
				$$COMMLOGSVC_SRC_PATH/qcommlogiterator.cpp \
				$$COMMLOGSVC_SRC_PATH/qcommlogservice.cpp \
				$$COMMLOGSVC_SRC_PATH/qcommlogdata.cpp
}

maemo {
    maemo5 {
        DEFINES += __MAEMO5__
        CONFIG(debug):QCOMMLOGSVC_SRC_PATH = ./platform/maemo5/
        CONFIG(debug):QCOMMLOGSVC_INC_PATH = ./platform/maemo5/
        CONFIG(release):QCOMMLOGSVC_SRC_PATH = ./platform/maemo5/
        CONFIG(release):QCOMMLOGSVC_INC_PATH = ./platform/maemo5/
        HEADERS =                qcommlogserviceinterface.h \
                                 qcommlogserviceplugin.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogservice.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogerrorcodes.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogkeyconstants.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogcallandsmsmodel.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommloggetlisttask.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogiterator.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogfilter.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogmodel.h \
                                 $$QCOMMLOGSVC_INC_PATH/qcommlogevent.h

        SOURCES =                qcommlogserviceplugin.cpp \
                                 $$QCOMMLOGSVC_SRC_PATH/qcommlogservice.cpp \
                                 $$QCOMMLOGSVC_SRC_PATH/qcommlogcallandsmsmodel.cpp \
                                 $$QCOMMLOGSVC_SRC_PATH/qcommloggetlisttask.cpp \
                                 $$QCOMMLOGSVC_SRC_PATH/qcommlogiterator.cpp \
                                 $$QCOMMLOGSVC_SRC_PATH/qcommlogfilter.cpp \
                                 $$QCOMMLOGSVC_SRC_PATH/qcommlogmodel.cpp \
                                 $$QCOMMLOGSVC_SRC_PATH/qcommlogevent.cpp
    } else {
        # maemo6
        DEFINES += __MAEMO6__
        CONFIG(debug):EVENTSVC_SRC_PATH = ./platform/maemo6/
        CONFIG(debug):EVENTSVC_INC_PATH = ./platform/maemo6/
        CONFIG(release):EVENTSVC_SRC_PATH = ./platform/maemo6/
        CONFIG(release):EVENTSVC_INC_PATH = ./platform/maemo6/
        HEADERS = ./qcommlogserviceinterface.h \
                                ./qcommlogserviceplugin.h \
                                $$EVENTSVC_INC_PATH/qcommlogiterator.h \
                                $$EVENTSVC_INC_PATH/commlogfilter.h \
                                $$EVENTSVC_INC_PATH/qcommlogerrorcodes.h \
                                $$EVENTSVC_INC_PATH/qcommlogkeyconstants.h \
                                $$EVENTSVC_INC_PATH/getcommloglisttask.h \
                                $$EVENTSVC_INC_PATH/commcallandsmsmodel.h \
                                $$EVENTSVC_INC_PATH/qcommlogservice.h

        SOURCES = ./qcommlogserviceplugin.cpp \
                                $$EVENTSVC_SRC_PATH/qcommlogiterator.cpp \
                                $$EVENTSVC_SRC_PATH/commlogfilter.cpp \
                                $$EVENTSVC_SRC_PATH/getcommloglisttask.cpp \
                                $$EVENTSVC_SRC_PATH/commcallandsmsmodel.cpp \
                                $$EVENTSVC_SRC_PATH/qcommlogservice.cpp
    }
}

TARGET = WrtApiCommLog
include(../cwrtservice.pri)

INCLUDEPATH += $$CWRT_INCLUDE


symbian {
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x20026153

    LIBS += -lefsrv \
            -lplatformenv \
            -leuser \
            -lapparc \
            -lcone \
            -leikcore \
            -leikcoctl \
            -lavkon \
            -lefsrv \
            -lbafl \
            -leikctl \
            -leikdlg \
            -laknnotify \
            -llogcli \
            -llogwrap
            
    VERSION = 3.0.0
    TARGET.sources = ./descriptionxml/commlogserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
  #  QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}

maemo {
  maemo5 {
    LIBS += -lrtcom-eventlogger
    LIBS += -lglib-2.0
    QT += sql

    # Build against wrt-dev package
    cwrt-services {
        LIBS += -L/usr/lib -lWrtSecurityManager
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }

    INCLUDEPATH += $$CWRT_INCLUDE \
        $$LMSVC_INC_PATH \
        /usr/include/rtcom-eventlogger \
        /usr/include/glib-2.0/ \
        /usr/include/glib-2.0/glib \
        /usr/lib/glib-2.0/include \
        ./platform/maemo5/
  } else {
    # maemo6 
    LIBS += -lcommhistory
    LIBS += -lQtContacts

    CONFIG += mobility
    INCLUDEPATH += $$CWRT_INCLUDE \
        $$EVENTSVC_INC_PATH \
        /usr/include/qt4/ \
        /usr/include/qt4/QtSql \
        /usr/include/qt4/QtContacts \
        /usr/include/commhistory/

    INCLUDEPATH    += ../../inc
    # Export description file
    EXPORT_FILE_NAME_BASE = commlogserviceplugin

    EXPORT_DIR = $$DESTDIR/import/
    EXPORT_SRC = descriptionxml/$$EXPORT_FILE_NAME_BASE.xml
    EXPORT_DST = $$EXPORT_DIR$$EXPORT_FILE_NAME_BASE.xml
    export_files_cmd.input = $$EXPORT_SRC
    export_files_cmd.output = $$EXPORT_DST
    export_files_cmd.commands = $(COPY) $$EXPORT_SRC $$EXPORT_DST
    export_files_cmd.CONFIG = target_predeps no_link
    export_files_cmd.clean = $$EXPORT_DST
    QMAKE_EXTRA_COMPILERS += export_files_cmd
  }
}
