/*
* ============================================================================
*  Name        : qcameraserviceinterface.h
*  Part of     : serviceproviders / WRT
*  Description : Interface for contact service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QCAMERASERVICEINTERFACE_H
#define QCAMERASERVICEINTERFACE_H

//QT Include
#include <QVariant>
#include <QString>
#include <QMap>
#include <qdatetime.h>

//Service Framework Include
#include "servicebase.h"

static const char* KICameraId = "com.nokia.ICamera/1.0";

// ITypeTest interface id.For Future use
static const ServiceInterfaceInfo KICameraInfo =
{
    KICameraId, 0
};

class ICamera : public IServiceBase
{
public:
    //public interfaces

    /**
     * QCameraService::getList()
     * This gets the list of image meta data within the given interval of time.
     @emits  void asyncCallback(int aStatus,int aTransactionId,QVariant pictureData )
     */
    virtual QVariant getList (QDateTime aStartTime, QDateTime aEndTime) = 0;

    /**
     * QCameraService::supportedSizes()
     * This method gives list of suppported sizes and mime types
     */
    virtual const QVariant supportedSizes() = 0;

    /**
     * QCameraService::startCamera()
     * This method launches the native camera application.
     */
    virtual QVariant startCamera() = 0;

};
Q_DECLARE_INTERFACE(ICamera, KICameraId);

#endif //QCAMERASERVICEINTERFACE_H
