/*
 * ============================================================================
 *  Name        : qcameraconstants.h
 *  Part of     : serviceframework / WRT
 *  Description : global constants for Camera service
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __CAMERACONSTANTS_H__
#define __CAMERACONSTANTS_H__

#include <QString>

//Error code key
const QString KCErrorCode( "ErrorCode" );
//Error message
const QString KCErrorMessage( "ErrorMessage" );

//Error codes
const int SUCCESS                         = 0;
const int MISSING_ARG_ERR                 = 1;
const int INVALID_ARG_ERR                 = 2;
const int NOT_SUPPORTED_ERR               = 3;
const int TIMEOUT_ERR                    = 100;
const int DATA_NOT_FOUND_ERR             = 101;
const int DATA_ALREADY_EXISTS_ERR        = 102;
const int SERVICE_BUSY_ERR               = 103;
const int SERVICE_IN_USE_ERR             = 104;
const int DATA_OUT_OF_RANGE_ERR          = 105;
const int NOT_ALLOWED_ERR                = 106;
const int SIZE_EXCEEDED_ERR              = 107;
const int INVALID_URI_ERR                = 108;
const int URI_NOT_FOUND_ERR              = 109;
const int URI_ALREADY_EXISTS_ERR         = 110;

//General Error Messages
const QString KCSuccess("Success");
const QString KCBadArgument("Invalid Argument or Out of range value");
const QString KCNotSupported("Not supported");
const QString KCServiceInUse("Service already in Use");
const QString KCNotAllowed("Operation is not allowed");
const QString KCDataExists("Data already exists");
const QString KCDataNotFound("Data not found");


const QString KCSupportedHeight("height");
const QString KCSupportedWidth("width");
const QString KCMimeType("type");
const QString KCUri("uri");
const QString KCFormatData("format");
const QString KCXpixels("xpixels");
const QString KCYpixels("ypixels");
const QString KSupportedSizesList("supportedSizes");
const QString KPictureData("picturedata");
const QString KErrorMap("errormap");

//Supported sizes. Defines
const int CAMERA_4X3_HIGH_WIDTH     = 2576;
const int CAMERA_4X3_HIGH_HEIGHT    = 1936;
const int CAMERA_4X3_MEDIUM_WIDTH   = 2048;
const int CAMERA_4X3_MEDIUM_HEIGHT  = 1536;
const int CAMERA_4X3_LOW_WIDTH      = 1280;
const int CAMERA_4X3_LOW_HEIGHT     = 960;

const int CAMERA_16X9_HIGH_WIDTH    = 2560;
const int CAMERA_16X9_HIGH_HEIGHT   = 1440;
const int CAMERA_16X9_MEDIUM_WIDTH  = 2560;
const int CAMERA_16X9_MEDIUM_HEIGHT = 1440;
const int CAMERA_16X9_LOW_WIDTH     = 2560;
const int CAMERA_16X9_LOW_HEIGHT    = 1440;

//Supported image types
const QString KCSupportedMimeImageType("image/jpeg");

//Supported file protocols
const QString KCSupportedFileProtocol("file://");

#endif //__CAMERACONSTANTS_H__
