/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "sfwservice.h"

namespace WRT {

/*!
    \class SFWService

    SFWService class is used by service metadata parser to keep service related information (service name, description, version and filepath)
    from service XML registry file\n
*/


/*!
 *  Class constructor
 *
 */
SFWService::SFWService()
{
}

/*!
 *  Class destructor
 */
SFWService::~SFWService()
{
    this->clear();
}

/*!
 *  Gets the service name
 *
 * @return service name
 */
QString SFWService::name()
{
    return m_name;
}

/*!
 *  Gets the service registration xml file name
 *
 * @return service registration xml file name
 */
QString SFWService::xmlFileName()
{
    return m_xmlFileName;
}


/*!
 *  Gets the service description
 *
 * @return interface description or default value (empty string) if it is not available
 */
QString  SFWService::description()
{
    return m_description;
}

/*!
 *  Gets the service version
 *
 * @return interface version
 */
QString  SFWService::version()
{
    return m_version;
}

/*!
 *  Gets the service filepath
 *
 * @return service filepath
 */
QString  SFWService::filePath()
{
    return m_filepath;
}

/*!
 *  Sets the service name
 *
 * @param aName
 */
void SFWService::setName(const QString& aName)
{
    m_name = aName;
}

/*!
 *  Sets the service registration xml file name
 *
 * @param aXMLFileName
 */
void SFWService::setXMLFileName(const QString& aXMLFileName)
{
    m_xmlFileName = aXMLFileName;
}

/*!
 *  Sets the service version
 *
 * @param aVersion
 */
void SFWService::setVersion(const QString& aVersion)
{
    m_version = aVersion;
}

/*!
 *  Sets the service filepath
 *
 * @param aFilePath
 */
void SFWService::setFilePath(const QString& aFilePath)
{
    m_filepath = aFilePath;
}

/*!
 *  Sets the service description
 *
 * @param aDescription
 */
void SFWService::setDescription(const QString& aDescription)
{
    m_description = aDescription;
}

/*!
 *  Add a new interface to set of service interfaces
 *
 * @param aInterface a pointer to a SFWInterface object
 */
void SFWService::addInterface(SFWInterface* aInterface)
{
    m_interfaces.append(aInterface);
}

/*!
 *  Gets the interface metadata
 *
 * @param aIndex [in] interface index
 * @return interface metadata if available, null otherwise
 */
SFWInterface* SFWService::getInterface(int aIndex)
{
    if (aIndex < m_interfaces.count()) {
        return m_interfaces[aIndex];
    }
/*    SFWInterface *emptyInterface = new SFWInterface();
    return *emptyInterface;*/
    return NULL;
}

/*!
 *  Gets the number of interfaces for service
 *
 * @return number of interfaces
 */
int SFWService::interfaceCount()
{
    return m_interfaces.count();
}

/*!
 *  Empty interface list for service and reset all service properties
 *
 */
void SFWService::clear()
{
    while (!m_interfaces.isEmpty()) {
        delete m_interfaces.takeFirst();
    }
    m_interfaces.clear();
    m_description = "";
    m_filepath = "";
    m_name = "";
    m_version = "";
}

}
