/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "sfwmodule.h"
#include "sfwinterface.h"

namespace WRT {

/*!
    \class SFWModule

    SFWModule class is used by service metadata parser to keep module related information
    (module name, description and its interfaces) from service XML registry file\n
*/


/*!
 *  Class constructor
 *
 * @param aName module name
 */
SFWModule::SFWModule(const QString& aName)
{
    moduleName = aName;
}

/**
 *  Class destructor
 */
SFWModule::~SFWModule()
{
    while (!interfaces.isEmpty()) {
        delete interfaces.takeFirst();
    }
    interfaces.clear();
}

/**
 *  Gets the module name
 *
 * @return module name or default value (empty string) if it is not available
 */
QString SFWModule::name()
{
    return moduleName;
}

/**
 *  Gets the module description
 *
 * @return module description or default value (empty string) if it is not available
 */
QString  SFWModule::description()
{
    return moduleDescription;
}

/**
 *  Gets the number of interfaces for the module
 *
 * @return Number of interfaces
 */
int SFWModule::interfaceCount()
{
    return interfaces.count();
}

/**
 *  Gets the interface metadata
 *
 * @param anIndex [in] interface index
 * @return method metadata if available, null otherwise
 */
SFWInterface* SFWModule::getInterface(int anIndex)
{
  if (anIndex < interfaces.count()) {
      return interfaces[anIndex];
  }
  return NULL;
}

/**
 *  Sets the module description
 *
 * @param aDescription
 */
void SFWModule::setDescription(const QString& aDescription)
{
    moduleDescription = aDescription;
}

/**
 * Adds an interface to the module  metadata
 *
 * @param anInterface interface pointer
 */
void SFWModule::addInterface(SFWInterface* anInterface)
{
    interfaces.append(anInterface);
}
}
