/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "sfwmethod.h"
#include "sfwparameter.h"

namespace WRT {

// ------------------------------------------------------------------------------
// SFWMethod::SFWMethod
// Class constructor
// ------------------------------------------------------------------------------
//
SFWMethod::SFWMethod(const QString& aName,const QString& aDescription)
{
    methodName = aName;
    methodDescription = aDescription;
}

// ------------------------------------------------------------------------------
// SFWMethod::~SFWMethod
// Class desctructor
// ------------------------------------------------------------------------------
//
SFWMethod::~SFWMethod(void)
{
    while (!inputParameters.isEmpty()) {
        delete inputParameters.takeFirst();
    }
    inputParameters.clear();

    while (!outputParameters.isEmpty()) {
        delete outputParameters.takeFirst();
    }
    outputParameters.clear();
}

// ------------------------------------------------------------------------------
// SFWMethod::name
//  Gets the method name
// ------------------------------------------------------------------------------
//
QString SFWMethod::name()
{
    return methodName;
}

// ------------------------------------------------------------------------------
// SFWMethod::inputParametersCount
// Number of input parameters for the method
// ------------------------------------------------------------------------------
//
int SFWMethod::inputParametersCount()
{
    return inputParameters.count();
}

// ------------------------------------------------------------------------------
// SFWMethod::getInputParameter
// Gets the input parameter metadata
// ------------------------------------------------------------------------------
//
SFWParameter* SFWMethod::getInputParameter(int anIndex)
{
    if (anIndex < inputParameters.count()) {
        return inputParameters[anIndex];
    }
    return NULL;
}

// ------------------------------------------------------------------------------
// SFWMethod::outputParametersCount
// Number of output parameters for the method
// ------------------------------------------------------------------------------
//
int SFWMethod::outputParametersCount()
{
    return outputParameters.count();
}

// ------------------------------------------------------------------------------
// SFWMethod::getOutputParameter
// Gets the output parameter metadata
// ------------------------------------------------------------------------------
//
SFWParameter* SFWMethod::getOutputParameter(int anIndex)
{
    if (anIndex < outputParameters.count()) {
        return outputParameters[anIndex];
    }
    return NULL;
}

// ------------------------------------------------------------------------------
// SFWMethod::response
// Gets the method response type
// ------------------------------------------------------------------------------
//
QString SFWMethod::response()
{
    return methodResponse;
}


// ------------------------------------------------------------------------------
// SFWMethod::description
// Gets the method description
// ------------------------------------------------------------------------------
//
QString SFWMethod::description()
{
    return methodDescription;
}

// ------------------------------------------------------------------------------
// SFWMethod::detailDescription
// Gets the method detailed description
// ------------------------------------------------------------------------------
//
QString SFWMethod::detailDescription()
{
    return methodDetailDescription;
}

// ------------------------------------------------------------------------------
// SFWMethod::setResponse
// Sets the method response type
// ------------------------------------------------------------------------------
//
void SFWMethod::setResponse(const QString& aResponse)
{
    methodResponse = aResponse;
}

// ------------------------------------------------------------------------------
// SFWMethod::setDetailDescription
// Sets the method detail description
// ------------------------------------------------------------------------------
//
void SFWMethod::setDetailDescription(const QString& aDescription)
{
    methodDetailDescription = aDescription;
}

// ------------------------------------------------------------------------------
// SFWMethod::addParameter
// Adds a method parameter to the method metadata
// ------------------------------------------------------------------------------
//
void SFWMethod::addParameter(const QString& aName, const QString& aType, const QString& aDescription, bool aMandatory,bool aDirection)
{
    SFWParameter* parameter = new SFWParameter(aName, aType, aDescription,aMandatory);
    if (aDirection) {
        inputParameters.append(parameter);
    } else {
        outputParameters.append(parameter);
    }
}
}
