/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef servicedatabasedefines_h
#define servicedatabasedefines_h

namespace WRT {

    //Database defines
    #define RESOLVERDATABASE "services.db"

    //logging messages
    #define ERROR_INVALID_SEARCH_CRITERIA_MESSAGE       "Invalid search criteria"
    #define ERROR_CANNOT_OPEN_DATABASE_MESSAGE          "Can not open DB"
    #define ERROR_CANNOT_CREATE_TABLES_MESSAGE          "Can not create tables"
    #define ERROR_CANNOT_DROP_TABLES_MESSAGE            "Can not drop tables"
    #define ERROR_DATABASE_NOT_OPEN_MESSAGE             "Database not open"
    #define ERROR_INVALID_DATABASE_CONNECTION_MESSAGE   "Invalid DB connection"
    #define ERROR_SERVICE_NOT_FOUND_MESSAGE             "Service not found"
    #define ERROR_CANNONT_CLOSE_DATABASE_MESSAGE        "Can not close DB"
    #define ERROR_BINDING_PARAM_VALUE_MESSAGE           "Can not bind value to query parameter"
    #define EERROR_FILE_PATH_UPDATED_MESSAGE            "Service file path updated"
    #define ERROR_SERVICE_ALREADY_REGISTERED_MESSAGE    "Service already registered"
    #define ERROR_DB_RECREATED_MESSAGE                  "DB recreated"
    #define OPEN_FUNC                                   "open"
    #define REGISTER_SERVICE_FUNC                       "registerService"
    #define GET_SERVICE_FUNC                            "getService"
    #define LIST_SERVICES_FUNC                          "listServices"
    #define CLOSE_FUNC                                  "close"
    #define CREATE_TABLES_FUNC                          "createTables"
    #define CHECK_TABLES_FUNC                           "checkTables"
    #define DROP_TABLES_FUNC                            "dropTables"


    //Tables
    #define RESOLVERDATABASE_SERVICE "Service"
    #define RESOLVERDATABASE_INTERFACE "Interface"

    //SQL defines

    //Create table
    #define RESOLVERDATABASE_CREATE_SERVICE_TABLE "CREATE TABLE Service(ID INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE,Name TEXT NOT NULL,\
                                                   Version TEXT NOT NULL,FilePath TEXT,Description TEXT, XMLFileName TEXT NOT NULL);"
    #define RESOLVERDATABASE_CREATE_INTERFACE_TABLE "CREATE TABLE Interface(ID INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE,ServiceID INTEGER NOT NULL,\
                                                     Name TEXT NOT NULL,Version TEXT NOT NULL,Capabilities TEXT,Description TEXT);"

    //Remove tables
    #define RESOLVERDATABASE_DROP_SERVICE_TABLE "DROP TABLE Service;"
    #define RESOLVERDATABASE_DROP_INTERFACE_TABLE "DROP TABLE Interface;"

    //Operations
    #define RESOLVERDATABASE_GET_SERVICES "SELECT DISTINCT Name,FilePath,Version,XMLFileName FROM Service;"
    #define RESOLVERDATABASE_GET_SERVICE "SELECT ID,FilePath,version FROM Service WHERE name=?;"
    #define RESOLVERDATABASE_INSERT_SERVICE_RECORD "INSERT INTO Service(Name,Version,FilePath,Description,XMLFileName) VALUES(?,?,?,?,?);"
    #define RESOLVERDATABASE_INSERT_INTERFACE_RECORD "INSERT INTO Interface(ServiceID,Name,Version,Capabilities,Description) VALUES(?,?,?,?,?);"
    #define RESOLVERDATABASE_DELETE_SERVICE_BY_ID "DELETE FROM Service WHERE ID=?;"
    #define RESOLVERDATABASE_DELETE_INTERFACE_BY_SERVICEID "DELETE FROM Interface WHERE ServiceID=?;"
    #define RESOLVERDATABASE_GET_SERVICEID_BY_SERVICENAME "SELECT ID FROM Service WHERE Name=?;"

    #define RESOLVERDATABASE_GET_SERVICE_INTERFACE_INFO "SELECT Service.version,Service.FilePath,Service.XMLFileName,Interface.version,\
                                        Interface.capabilities FROM Service,Interface WHERE Service.ID=Interface.ServiceID AND \
                                        Service.name=? AND Interface.version >= ? AND Interface.version < ? AND Interface.name=? ORDER BY Interface.version DESC;"


    //Default Sql connection
    #define RESOLVERDATABASE_DEFAULT_CONNECTION "qt_sql_default_connection"

    #define RESOLVERDATABASE_GET_LATEST_INTERFACE_VERSION_BY_NAME "SELECT MAX(interface.version) FROM interface,service WHERE interface.name=? AND interface.ServiceID=service.id AND service.name=?;"

#ifdef __SYMBIAN32__
    #define RESOLVERDATABASE_ROMINFO "RomInfo"
    #define RESOLVERDATABASE_CREATE_ROMINFO_TABLE "CREATE TABLE RomInfo(RomImageVersion TEXT NOT NULL);"
    #define RESOLVERDATABASE_DROP_ROMINFO_TABLE "DROP TABLE RomInfo;"
    #define RESOLVERDATABASE_INSERT_ROMINFO_RECORD "INSERT INTO RomInfo(RomImageVersion) VALUES(?);"
    #define RESOLVERDATABASE_UPDATE_ROMINFO_RECORD "UPDATE RomInfo SET RomImageVersion=?;"
    #define RESOLVERDATABASE_GET_ROMIMAGE_VERSION "SELECT DISTINCT RomImageVersion FROM RomInfo;"
#endif

}

#endif //servicedatabasedefines_h
