/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#include "bindingdef.h"
#include "npplugin.h"
#include <QtGlobal>

namespace WRT
{

/*!
    \class NPPlugin
    \brief The NPPlugin object is the plugin instance data required by NPP_New.

    It also a factory for the ServiceFactory object.

    \sa NPP_New in NPAPI online
*/

/*!
    Constructs a NPPlugin instance data with the given \a npp.

    @param npp represents a single instance of a plugin
*/
NPPlugin::NPPlugin(NPP npp) :
  m_npp(npp),
  m_pFactory(NULL)
{
}

/*!
    Destroys plugin instance data.
*/
NPPlugin::~NPPlugin()
{
    if (m_pFactory) {
        NPN_ReleaseObject(m_pFactory);
        m_pFactory = NULL;
    }
}

/*!
    Create service factory object

    @return servcie fatory object
*/
NPObject* NPPlugin::GetFactory()
{
    if (!m_pFactory) {
        m_pFactory = createFactoryObject(m_npp);
    }

#ifndef  __SYMBIAN32__
    if (m_pFactory) {
        NPN_RetainObject(m_pFactory);
    }
#endif

    return m_pFactory;
}

}
