/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "sfwlog.h"
#ifdef __SYMBIAN32__
#include <QCoreApplication>
#include "np_entry.h"
#endif // __SYMBIAN32__

#include "bindingdef.h"
#include <QtGlobal>

#ifndef OSCALL
#ifdef Q_OS_WIN32
   #define OSCALL WINAPI
#else
   #define OSCALL
#endif
#endif

#ifdef __linux__
  #ifdef Bool
    #undef Bool
  #endif
#endif

//forward declaration for Windows extra setup
#ifdef Q_OS_WIN32
extern "C" void handlePluginShutdown();
extern "C" void handlePluginInitialize();
#endif

#ifndef HIBYTE
#define HIBYTE(x) ((((uint32)(x)) & 0xff00) >> 8)
#endif

// The global object which maintains the pointers to the browser's functions
//
extern NPNetscapeFuncs* NPNFuncs;

#ifdef __linux__
static const char* KSFWPluginName = "NOKIA_ServiceFramework";
static const char* KSFWPluginDescription = "nokia cross-platform service framework based plugin";
#endif

// The function is called after NP_Initialize is called and returns successfully.
// It allows browser to plug-in's routines without using standard DLL calling conventions
NPError OSCALL NP_GetEntryPoints(NPPluginFuncs* pFuncs)
{
    NPError error = NPERR_NO_ERROR;

    if (pFuncs) {
#ifndef __SYMBIAN32__
        if (pFuncs->size < sizeof(NPPluginFuncs)) {
            return NPERR_INVALID_FUNCTABLE_ERROR;
        }
        pFuncs->version       = (NP_VERSION_MAJOR << 8) | NP_VERSION_MINOR;

#else // __SYMBIAN32__
        pFuncs->size          = sizeof(NPPluginFuncs);
        pFuncs->version       = 1;
#endif // __SYMBIAN32__
        pFuncs->newp          = NPP_New;
        pFuncs->destroy       = NPP_Destroy;
        pFuncs->setwindow     = NPP_SetWindow;
        pFuncs->newstream     = NPP_NewStream;
        pFuncs->destroystream = NPP_DestroyStream;
        pFuncs->asfile        = NPP_StreamAsFile;
        pFuncs->writeready    = NPP_WriteReady;
#if defined(__SYMBIAN32__) && !defined (CWRT_S60_WEBKIT)
        pFuncs->write         = NPP_Write;
#else
        pFuncs->write         = NPP_WriteProcPtr(NPP_Write);
#endif
        pFuncs->print         = NPP_Print;
        pFuncs->event         = NPP_HandleEvent;
        pFuncs->urlnotify     = NPP_URLNotify;
        pFuncs->getvalue      = NPP_GetValue;
        pFuncs->setvalue      = NPP_SetValue;
        pFuncs->javaClass     = NULL;
    }
    else {
        error = NPERR_INVALID_FUNCTABLE_ERROR;
    }
    return error;
}

// The function is called right after the plugin is loaded.
// A global object is maintained future calls to the browser
#ifdef __linux__
extern "C" NPError NP_Initialize(NPNetscapeFuncs *pFuncs, NPPluginFuncs *pluginFuncs)
#else
NPError OSCALL NP_Initialize(NPNetscapeFuncs* pFuncs)
#endif //__linux__
{
    NPError error = NPERR_NO_ERROR;
    if (!pFuncs) {
        error =  NPERR_INVALID_FUNCTABLE_ERROR;
    } else if (HIBYTE(pFuncs->version) > NP_VERSION_MAJOR) {
        error = NPERR_INCOMPATIBLE_VERSION_ERROR;
    } else {
        NPNFuncs = pFuncs;
#ifdef Q_OS_WIN32
        handlePluginInitialize();
#endif

#if defined(__SYMBIAN32__) && !defined (CWRT_S60_WEBKIT)
        // Do not duplicately create a core application
        //
        if ( !QCoreApplication::instance() )
            {
            TInt zero(0);
            char** ptr(NULL);
            // Qt global variable will hold the object.
            new QCoreApplication(zero,ptr);
            }
#endif // __SYMBIAN32__
        bindingInitialize(NPNFuncs);
    }
#ifdef __linux__
    return NP_GetEntryPoints(pluginFuncs);
#else
    return error;
#endif //Q_WS_X11
}

// It is called immediately before the plug-in is unloaded
#ifdef __linux__
extern "C" void NP_Shutdown(void)
#else
NPError OSCALL NP_Shutdown()
#endif
{
    SFW_DEBUG1("NP_Shutdown");
#if defined(__SYMBIAN32__) && !defined (CWRT_S60_WEBKIT)
    delete qApp;
#endif

#ifdef Q_OS_WIN32
    handlePluginShutdown();
#endif // Q_OS_WIN32
#ifndef __linux__
    return NPERR_NO_ERROR;
#endif // Q_OS_WIN32
}

#ifdef __linux__
#include <QByteArray>
extern "C" char*  NP_GetMIMEDescription()
{
    // TODO: define the mime type in def
    return ((char*)"application/x-sfw-plugin:xxx:swfPlugin");
}

extern "C" NPError
NP_GetValue(void*, NPPVariable aVariable, void *aValue)
{
    NPError err = NPERR_NO_ERROR;

    switch (aVariable) {
    case NPPVpluginNameString:
        *static_cast<const char **> (aValue) = KSFWPluginName;
        break;
    case NPPVpluginDescriptionString:
        *static_cast<const char **>(aValue) = KSFWPluginDescription;
        break;
    case NPPVpluginNeedsXEmbed:
        *static_cast<int*>(aValue) = false;
        break;
    case NPPVpluginTimerInterval:
    case NPPVpluginKeepLibraryInMemory:
    default:
        err = NPERR_INVALID_PARAM;
        break;
    }

    return err;
}
#endif //__linux__
