/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef objectbinding_h
#define objectbinding_h

#include "npdef.h"


#include "scriptableobjectbase.h"
#include "sfwerrorhandler.h"

namespace WRT {

    enum MetaOffset {
        MetaProperty = 0,
        MetaMethod};
    static const char *ObjectBindingErrDesc[] ATTRIBUTE_USED = {"No Error",
                                                                "Method not found",
                                                                "Number of parameter not correct",
                                                                "Parameter type mismatch",
                                                                "Interface not defined",
                                                                "Signal not found",
                                                                "No connection mapped to connection Id"
                                                                };

    //Forward declaration
    class BindingUtility;
    class ServiceFactory;

    class ObjectBinding : public NPScriptableObjectBase, public SFWErrorHandler
    {
    public:
        //! ObjectBinding::ErrorType
        /*!
         This enum describes the errors that may occur in binding layer
         */
        enum ErrorType {
            SFW_ERROR_NO_ERROR,                                       /*!< No error */
            SFW_ERROR_SLOT_NOT_FOUND,                                 /*!< Can not find the requested service method*/
            SFW_ERROR_NUMBER_OF_PARAMETERS,                           /*!< Error in number of input parameters */
            SFW_ERROR_PARAMETER_TYPE_MISMATCH,                        /*!< Error an input parameter type mismatch*/
            SFW_ERROR_INTERFACE_NOT_FOUND,                            /*!< No interface with the given name defined in service */
            SFW_ERROR_SIGNAL_NOT_FOUND,                               /*!< No signal with the given signature found */
            SFW_ERROR_CONNECTIONID_NOT_FOUND                          /*!< No connection established for the given connection id */
        };

        ObjectBinding(NPP npp);
        virtual ~ObjectBinding();

        //Overriding virtual methods of NPScriptableObjectBase
        virtual bool HasMethod(NPIdentifier methodId);
        virtual bool HasProperty(NPIdentifier propertyId);
        virtual bool GetProperty(NPIdentifier propertyId, NPVariant *result);
        virtual bool SetProperty(NPIdentifier propertyId, const NPVariant *value);
        virtual bool Invoke(NPIdentifier methodId, const NPVariant *args,
                            uint32_t argCount, NPVariant *result);
        void setObject(QObject* aObj,
                       BindingUtility& bindingUtility,
                       bool takeQObject);
        void setFactory(ServiceFactory* factory);

    protected:
        int indexOfSignal(const NPString* signalSignature);
        int indexOfSlot(const QByteArray& slotName,
                        QVector<QVariant>* variants=NULL);
    private:
        bool prepareParameters(const NPVariant *args,
                               int argCount,
                               QVector<QVariant>& variants,
                               QVector<const void*>& metacallArgs);
        bool matchParameters(QList<QByteArray>& parameterTypes,
                             QVector<QVariant>& variants);
        //static NPObject* AllocateObjectBinding(NPP npp, NPClass* /*aClass*/);
    protected:
        BindingUtility* m_bindingUtility; // Not Owned
        QObject*  m_object; //an embedded QObject
        ServiceFactory* m_factory; //pointer to factory object
        bool m_owned; // the m_object is owned by this object
        MetaOffset m_metaOffsetType;
    };

    DECLARE_NPOBJECT_CLASS_WITH_BASE(ObjectBinding);
}
#endif //objectbinding_h
