/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef bindingutility_h
#define bindingutility_h

#include "npdef.h"

#include <QVariant>

class QByteArray;

namespace WRT {
    static const char *BindingUtilityErrDesc[] ATTRIBUTE_USED = {"No Error",
                                                                 "Invalid UTC date",
                                                                 "Invalid integer number",
                                                                 "Parameter has undefined type"
                                                                 };

    class BindingUtility
    {
#ifdef  __SYMBIAN32__
    public: // data type
        enum JSObjectTypes{
            DateObject = 0,
            ArrayObject,
            NumberObject,
            BooleanObject,
            StringObject,
            JSObjectTypesCount};
        enum Identifiers{
            Constructor = 0,
            ToString,
            Null,
            ValueOf,
            IdentifiersCount
        };
#endif
    public:
        //! BindingUtility::ErrorType
        /*!
         This enum describes the errors that may occur in binding layer, converting JS vars to QT vars
         */
        enum ErrorType {
            SFW_ERROR_NO_ERROR,                                       /*!< No error */
            SFW_ERROR_INAVLID_DATE,                                   /*!< Not a valid date according to UTC time spec*/
            SFW_ERROR_INVALID_INT,                                    /*!< Not a valid integer number */
            SFW_ERROR_UNDEFINED_TYPE                                  /*!< Undefined type parameter */
        };

        BindingUtility(NPP npp);
        virtual ~BindingUtility();

    public:
        QVariant toQVariant(const NPVariant& var);
        NPVariant fromQVariant(const QVariant &qvariant);
        NPObject* Evaluate(const QByteArray& script);
        NPObject* windowObject();
        void initNPFunctionPrototypes(NPObject* objProto,
                                      NPObject* arrayProto,
                                      NPObject* dateProto);
    public: // static functions
        static QString NPStringToQString(const NPString* aString);
        static QByteArray NPStringToQByteArray(const NPString* aString);
        static void freeNPString(NPString& aString);
        static void freeNPVariant(NPVariant& aVariant);
    private:
        QVariant fromArray(NPObject* npObject,
                           NPIdentifier* propIds,
                           uint32_t propCount);
        QVariant fromDate(NPObject* npObject);
        QVariant fromNumber(NPObject* npObject);
        QVariant fromString(NPObject* npObject);
        QVariant fromBool(NPObject* npObject);
        QVariant fromObject(NPObject* npObject,
                            NPIdentifier* propIds,
                            uint32_t propCount);
    private:
        NPP m_npp; //plug-in's instance handle
        NPObject* m_windowObject;
#ifdef  __SYMBIAN32__
        NPIdentifier m_Ids[IdentifiersCount];
        NPVariant m_scripts[JSObjectTypesCount]; // scripts to create JS objects
        TUint8* m_constructor[JSObjectTypesCount];
#endif
        NPIdentifier m_npidCall;
        NPObject* m_objectFunc;
        NPObject* m_dateFunc;
        NPObject* m_arrayFunc;
    };

    // MACROS
    #define NPSTRING_LENGTH(npString) (npString).UTF8Length
    #define NPSTRING_UTF8(npString) (npString).UTF8Characters

} //namespace
#endif // bindingutility_h
