/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceplugininterface_h
#define serviceplugininterface_h

class IServiceBase;
namespace WRT {
    class SecSession;
}


/**
* Interface class for service provider plugins
*
*/
class IServicePlugin
{
public:

    /**
    * Return IServiceBase pointer to service object which provide the service
    * to clients of service framework. e.g browser plugin/java script, webkit
    * or Qt application.
    *
    * @param refCounted true interface is reference counted
    * @param secSession Security Manager session - not owned
    * @return the interface pointer to service object. The ownership of the
              service object is transferred.
    */
    virtual IServiceBase* getServiceBase(bool refCounted, WRT::SecSession *secSession) = 0;
};

Q_DECLARE_INTERFACE(IServicePlugin, "com.nokia.serviceplugin/1.0")

#endif //serviceplugininterface_h
