/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef iterable_h
#define iterable_h

namespace WRT {

/**
* Interface class for iterable interface implemented by service provider.

* Note, when service provider implments this interface, it must derive from
* this interface and QObject. e.g.
* CMyCollection : public QObject, public IIterable
* {
* public:
*   CMyCollection();
*   ....
* }
*
*/
    class IIterable
    {
    public:

        /**
        * Resets the iterator
        *
        * The service provider should provide a concrete
        * implementation to reset the iterator.
        *
        */
        virtual void reset() = 0;

        /**
        * Check if there is next item available
        *
        * The service provider should provide a concrete implementation
        * for this method.
        *
        * @return false if there are no more data elements to be fetched;
        *         true otherwise
        *
        */
        virtual bool hasNext() = 0;

        /**
        * Get current item in the collection and get ready for next item.
        *
        * The service provider should provide a concrete implementation
        * for this method.
        *
        * @return current data entry
        *
        */
        virtual QVariant next() = 0;

        /**
        * Free resources in the collection
        * The service provider should provide a concrete implementation
        * for this method.
        */
        virtual void close() = 0;
    };
}
#endif //iterable_h
