/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_TRUSTPROPHANDLER_H
#define __WRT_TRUSTPROPHANDLER_H

#include <QString>

namespace WRT {

    class TrustParser;

    /*!
    * Definition of interface TrustPropHandler
    */
    class TrustPropHandler {
    public:
        /*!
        * Sets the parser for this handler
        * \param[in] aParser - The parser for this handler
        */
        virtual void setParser(TrustParser *parser)
        {
            m_parser = parser;
        }

        /*!
        * Gets the domain for a specified value
        * \param[in] aValue - Value to get the domain for
        * \return The requested domain
        */
        virtual QString domainFor(const QString &value) = 0;

    protected:    // data
        TrustParser *m_parser;   // not owned
    };

}

#endif  // __WRT_TRUSTPROPHANDLER_H
