/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRT_SECMGRDEFS_H
#define __WRT_SECMGRDEFS_H

//  INCLUDES

namespace WRT {
    static const char KNAME[]           = "name";
    static const char KORIGIN[]         = "origin";
    static const char KAPPPATH[]        = "appPath";
    static const char KURL[]            = "url";
    static const char KPROCESS[]        = "process";
    static const char KID[]             = "id";
    static const char KCERTIFICATE[]    = "certificate";
    static const char KAKI[]            = "aki";
    static const char KONESHOT[]        = "oneshot";
    static const char KSESSION[]        = "session";
    static const char KBLANKET[]        = "blanket";
    static const char KALIAS[]          = "alias";
    static const char KDOMAIN[]         = "domain";
    static const char KDEFAULTDOMAIN[]  = "defaultdomain";
    static const char KCAPABILITY[]     = "capability";
    static const char KUSER[]           = "user";
    static const char KDEFAULTSCOPE[]   = "defaultScope";
    static const char KSCOPE[]          = "scope";
    static const char KTYPE[]           = "type";
    static const char KGRANT[]          = "grant";
    static const char KDISPLAYTEXT[]    = "displaytext";
    static const char KCLIENTNAME[]     = "clientname";
    static const char KWIDGETPATH[]     = "widgetpath";
    static const char KWIDGETDATAPATH[] = "widgetdatapath";


    enum TrustCriteriaType {
        ETrustCriteriaOrigin = 0,
        ETrustCriteriaProcessId,
        ETrustCriteriaCertificate,
        ETrustCriteriaAppPath
    };
}

#endif  // __WRT_SECMGRDEFS_H
