/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_POLICY_SERIALIZER_H
#define __WRT_POLICY_SERIALIZER_H

#include "capability.h"

namespace WRT {

    /*!
    * Base class definition of interface PolicySerializer.
    */
    class PolicySerializer
    {
    public:
        virtual ~PolicySerializer(){}
        /*!
        * Persists and stored the policy file in an internal representation
        * \param[in] key - Key for this policy
        * \param[in] store - Directory of where to store
        * \param[in] domain - Domain for which to store data related to
        * \param[in] capabilities - Capability set to store
        * \param[in] aliases - Aliases of which to store
        * \return TRUE if persist succeeds, else returns FALSE.
        */
        virtual bool persist( const QString &key,
                              const QString &store,
                              const QString &domain,
                              const CapabilitySet *capabilities,
                              const AliasSet *aliases ) = 0;

        virtual bool persist(QByteArray &blob,
                             const QString &domain,
                             const CapabilitySet *capabilities,
                             const AliasSet *aliases) = 0;


    protected:
    };
}

#endif  // __WRT_POLICY_SERIALIZER_H
