/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRT_SECPARSER_H
#define __WRT_SECPARSER_H

#include <QList>
#include <QStringList>
#include <QVariant>
#include "capability.h"
#include "usercondition.h"

// FORWARD DECLARATIONS
class QXmlStreamReader;

namespace WRT {

    class UserConditionHandler;
    class UserConditionSerializer;

    class PolicyParser: public QObject
    {
        Q_OBJECT
    public:
        PolicyParser(const QString &policy);
        PolicyParser(const QByteArray &policy);
        ~PolicyParser();

        //===========================================================
        // Own interface methods
        //===========================================================
        bool parse(const QString &domain);
        bool parse();
        QStringList domains() const;
        const QString defaultDomain() const;
        const CapabilitySet *capabilities(const QString &domain) const;
        const QStringList aliasesFor(const QString &capability) const;
        bool hasAlias(const QString &capability) const;
        const AliasSet *aliases() const;
        void setUserHandler(const UserConditionHandler *handler);
        void setSerializer(UserConditionSerializer *serializer);

    private:    // methods
        void cleanup();
        void createConditionTable();
        bool processAlias();
        QString processCapability();
        bool processDomain();
        bool processUserSection(const QString &domainName);
        QString processDefaultScope();
        QString processScope();
        unsigned int processGrant();

    private:
        QXmlStreamReader *m_xmlReader;
        const UserConditionHandler *m_conditionHandler;
        UserConditionSerializer *m_conditionSerializer;
        QHash<QString, UserGrant> m_conditionTable;
        QHash<QString, CapabilitySet*> m_domains;
        //NOTE: two hash tables are created for aliases, one hashed by alias name
        //      and the other hashed by capability.  This is for faster lookup since
        //      QHash is optimized for fast lookup by key, not by value.
        AliasSet m_aliasSet;
        QHash<QString, QStringList> m_capAliases;
    };

}
#endif  // __WRT_SECPARSER_H
