#
# ============================================================================
#  Name        : securestorageserver.pro
#  Part of     : ECWRT
#  Description : Project definition file for project securestorageserver
#  Version     : %version: 1 %
#
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

TEMPLATE = app
TARGET = wrtsecurestorageserver

QT        -= gui
QT        += xml

ROOT_DIR = $$PWD/../../../../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)

INCLUDEPATH += $$WRT_DIR/ipc/serviceipcserver

HEADERS   += ../../qt/securestorageserver/securestorageserver.h \
             ../../qt/securestorageserver/securestorageserversession.h \
             ../../qt/securestorageserver/securestorageserverentry.h \
             ../../qt/securestoragemetadata.h \
             ../../qt/securestoragedefs.h \
             ../../../sslog.h

SOURCES   += ../../qt/securestorageserver/securestorageserver.cpp \
             ../../qt/securestorageserver/securestorageserversession.cpp \
             ../../qt/securestoragemetadata.cpp \
             ../../qt/securestorageserver/securestoragemain.cpp

INCLUDEPATH += . ../../qt/ ../../qt/securestorageserver/
INCLUDEPATH += $$CWRT_INCLUDE

LIBS += -L$$DESTDIR -lwrtserviceipcserver

contains ( what, cleanenv) {
    DEFINES += S60_CLEAN_ENV
     myCleanBuild = \
     "$${LITERAL_HASH}define S60_CLEAN_ENV"

     MMP_RULES += myCleanBuild
}

symbian {
    HEADERS += ../../symbian/securestorageserver/securestoragesymbian.h
    SOURCES += ../../symbian/securestorageserver/securestoragesymbian.cpp
    LIBS += -lefsrv -lsysutil
    TARGET.CAPABILITY = ALL -TCB -DRM
    TARGET.UID3 = 0x102829CB
    TARGET.VID = 0x101FB657
    INCLUDEPATH += $$APP_LAYER_SYSTEMINCLUDE
    INCLUDEPATH += /epoc32/include/internal


    browsertrustpolicy.sources = ./resources/browser_trust_policy.xml
    browsertrustpolicy.path = /private/102829CB/policy/1234567890
    browseraccesspolicy.sources = ./resources/browser_access_policy.xml
    browseraccesspolicy.path = /private/102829CB/policy/1234567890
    backupregistration.sources = ./resources/backup_registration.xml
    backupregistration.path = /private/102829CB

contains( what, ROM ) {
    # Export z-drive policy files only for ROM image
    browsertrustpolicymd5.sources = ./resources/z/browser_trust_policy.xml.md5
    browsertrustpolicymd5.path = /private/102829CB/shared/policysigned/metafiles/1234567890
    browseraccesspolicymd5.sources = ./resources/z/browser_access_policy.xml.md5
    browseraccesspolicymd5.path = /private/102829CB/shared/policysigned/metafiles/1234567890
} else {
    browsertrustpolicymd5.sources = ./resources/browser_trust_policy.xml.md5
    browsertrustpolicymd5.path = /private/102829CB/shared/policysigned/metafiles/1234567890
    browseraccesspolicymd5.sources = ./resources/browser_access_policy.xml.md5
    browseraccesspolicymd5.path = /private/102829CB/shared/policysigned/metafiles/1234567890
}

    DEPLOYMENT += browsertrustpolicy \
                  browseraccesspolicy \
                  browsertrustpolicymd5 \
                  browseraccesspolicymd5 \
                  backupregistration

    # Export headers on symbian, setup the emulator
    BLD_INF_RULES.prj_exports += \
        "./resources/browser_access_policy.xml      /epoc32/winscw/c/private/102829CB/policy/1234567890/browser_access_policy.xml" \
        "./resources/browser_trust_policy.xml       /epoc32/winscw/c/private/102829CB/policy/1234567890/browser_trust_policy.xml" \
        "./resources/browser_access_policy.xml.md5  /epoc32/winscw/c/private/102829CB/shared/policysigned/metafiles/1234567890/browser_access_policy.xml.md5" \
        "./resources/browser_trust_policy.xml.md5   /epoc32/winscw/c/private/102829CB/shared/policysigned/metafiles/1234567890/browser_trust_policy.xml.md5" \
        "./resources/backup_registration.xml        /epoc32/winscw/c/private/102829CB/backup_registration.xml"

    RSS_RULES += "hidden = KAppIsHidden;"

    myIfdefBlock = \
    "$${LITERAL_HASH}if (!defined(WINSCW) && !defined(S60_CLEAN_ENV))" \
    "LIBRARY secenv.lib" \
    "$${LITERAL_HASH}endif"

    MMP_RULES += myIfdefBlock
}
