/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WRT_SECURESTORAGEMETADATA_H
#define __WRT_SECURESTORAGEMETADATA_H

#include <QObject>
#include <QString>
#include <QByteArray>
#include <QIODevice>

namespace WRT
{
    class SecureStorageMetadata : public QObject
        {
        Q_OBJECT
    public:
        SecureStorageMetadata(QObject *aParent = NULL);
        ~SecureStorageMetadata();
        void setSourceFile(const QString &aSourceFile);
        const QString sourceFile() const;
        void setHash(const QByteArray &aHash);
        const QByteArray hash() const;
        bool internalize(QIODevice &aDevice);
        bool externalize(QIODevice &aDevice) const;
    private:
        // METHODS
    private:
        // MEMBERS
        QString m_sourceFile;
        QByteArray m_hash;
        };
}
#endif  // __WRT_SECURESTORAGEMETADATA_H
