/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WRT_SECURESTORAGECLIENT_H
#define __WRT_SECURESTORAGECLIENT_H

#include "securestorage.h"

/**
* Class export macro
*/
#if defined(QT_MAKE_SECURESTORAGE_DLL)
#define SECURESTORAGECLIENT_API Q_DECL_EXPORT
#else
#define SECURESTORAGECLIENT_API Q_DECL_IMPORT
#endif

namespace WRT {

    // FORWARD DECLARATIONS
    class ServiceFwIPC;

    class SECURESTORAGECLIENT_API SecureStorageClient : public SecureStorage
    {
        Q_OBJECT
    public:
        SecureStorageClient(const QString &aStorageName,
                            Storage::visibility = vis_shared,
                            Storage::protection = prot_signed,
                            QObject* aParent = 0);
        virtual ~SecureStorageClient();

    protected:  // new methods
        virtual void initStorage();

    protected:  // from SecureStorage
        virtual QHash<QString, QString> updateFileList() const;
        virtual void saveFileList();
        virtual void saveMetadata(const SecureStorageMetadata &aMetadata);
        virtual void removeMetadata(const QString &aFileName);
        virtual SecureStorageMetadata *getMetadata(const QString &aFileName) const;

    protected:  // members
        ServiceFwIPC *m_IPCClient;  // owned
    };
}

#endif  // __WRT_SECURESTORAGECLIENT_H
