/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __RUNTIMEGLOBAL_H__
#define __RUNTIMEGLOBAL_H__

#include <QtCore/qglobal.h>

#define WRT_ORGANIZATION_DOMAIN "com.nokia"
#define WRT_ORGANIZATION_NAME "Nokia"

#ifndef RUNTIME_EXPORT
#if defined(BUILD_RUNTIME_CORE)
    #define RUNTIME_EXPORT Q_DECL_EXPORT
#else
    #define RUNTIME_EXPORT Q_DECL_IMPORT
#endif
#endif

/*
 * WRT_CAPTURE_TRACE macro can be used by instrumenting trace hooks in the code.
 * It emits the signal WRT::WrtPage::captureTrace that can be captured in the
 * benchmarking or tracing code (e.g., class WrtPerfTracer)
 *
 * Argument for this macro:
 *     wrtpage - Pointer to WrtPage (will be used to pass current QWebFrame* in signal)
 *     context - Freeform text used as key for identifying source of signal (typically function name)
 *     value   - Custom value that can be passed in signal (e.g., URL)
 *
 * When using this macro, please remember to add appropriate friend class to runtimecore/wrtpage.h
 *
 * For production builds, where ENABLE_TRACE_SIGNAL is undefined, this macro becomes NOOP.
 * Run "qmake wrt_tracing=on" to set ENABLE_TRACE_SIGNAL
 *
 */
#if defined(ENABLE_TRACE_SIGNAL)
#define WRT_CAPTURE_TRACE(wrtpage, context, value) \
    if ((wrtpage)) emit (wrtpage)->captureTrace(((wrtpage)->currentFrame()), (context), (value));
#else
#define WRT_CAPTURE_TRACE(wrtpage, context, value) ((void)0)
#endif

#endif // __RUNTIMEGLOBAL_H__

