# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

#
# runtimecore.pro
#


TEMPLATE = lib
TARGET = WrtRuntimeCore
DEFINES += BUILD_RUNTIME_CORE
QT += network webkit

contains( what, ninetwo ) {
QT += webkit
DEFINES += CWRT_BUILDING_NINETWO
}

contains( what, qt_unstable ) {
    DEFINES += CWRT_BUILDING_QTUNSTABLE
}

ROOT_DIR = $$PWD/../..
WRT_DIR = $$ROOT_DIR/wrt
include($$ROOT_DIR/shared.pri)

maemo6 {
    include($$ROOT_DIR/wrt/cwrt.pri)
} else {
    include($$WRT_DIR/cwrt-webkit.pri)
} 

message ("using webkit: $$WEBKIT_DIR")
    
include($$WRT_DIR/wrt.pri)

LIBS += -lWrtSettings


CONFIG += \
    building-libs \
    depend_includepath \
    dll \
    link_prl \
    create_prl


contains(QT_CONFIG, embedded): CONFIG += embedded

CONFIG(release, debug|release):!CONFIG(QTDIR_build){
    contains(QT_CONFIG, reduce_exports): CONFIG += hide_symbols
    unix:!symbian: contains(QT_CONFIG, reduce_relocations): CONFIG += bsymbolic_functions
}

CONFIG -= warn_on
*-g++* : QMAKE_CXXFLAGS += -Wreturn-type -fno-strict-aliasing

CONFIG(gcov)   {
   LIBS +=   -lgcov
   QMAKE_CXXFLAGS += -fprofile-arcs -ftest-coverage
}

include($$WRT_DIR/cwrt-export.pri)

#
# SOURCE and HEADER lists
#
HEADERS += \
    $$PWD/resources/qtnstrings.h \
    $$PWD/resources/qtnresources.h \
    $$PWD/resources/wrtversions.h \
    $$PWD/webnavigation.h \
    $$PWD/webtouchnavigation.h \
    $$PWD/webcursornavigation.h \
    $$PWD/webhtmltabbednavigation.h \
    $$PWD/webdirectionalnavigation.h \
    $$PWD/wrtpage.h \
    $$PWD/wrtwebview.h \
    $$PWD/wrtgraphicswebview.h \
    $$PWD/wrtcontroller.h \
    $$PWD/wrtcontroller_p.h


SOURCES += \
    $$PWD/webnavigation.cpp \
    $$PWD/webtouchnavigation.cpp \
    $$PWD/webcursornavigation.cpp \
    $$PWD/webhtmltabbednavigation.cpp \
    $$PWD/webdirectionalnavigation.cpp \
    $$PWD/wrtpage.cpp \
    $$PWD/wrtwebview.cpp \
    $$PWD/wrtgraphicswebview.cpp \
    $$PWD/wrtcontroller.cpp


#
# INCLUDE PATHS
#
INCLUDEPATH += \
    $$PWD \
    $$PWD/../ \
    $$PWD/../settings/inc

unix:!symbian {
    headers_runtimecore.files = \
        $$PWD/qtnstrings.h \
        $$PWD/runtimeglobal.h \
        $$PWD/webcursornavigation.h \
        $$PWD/webdirectionalnavigation.h \
        $$PWD/webhtmltabbednavigation.h \
        $$PWD/webnavigation.h \
        $$PWD/webtouchnavigation.h \
        $$PWD/wrtcontroller.h \
        $$PWD/wrtpage.h
    headers_runtimecore.path = $$CWRT_INSTALL_INC_DIR/wrt/runtimecore

    headers_runtimecore_resources.files = \
        $$PWD/resources/qtnresources.h \
        $$PWD/resources/qtnstrings.h \
        $$PWD/resources/wrtversions.h
    headers_runtimecore_resources.path = $$CWRT_INSTALL_INC_DIR/wrt/runtimecore/resources

    INSTALLS += headers_runtimecore headers_runtimecore_resources
}
